/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.w3c.dom.css.CSSValue;

public class CSSResourcesHelpersTest
extends CSSSWTHelperTestCase {
    public void testGetCSSValueKeyWhenFont() throws Exception {
        CSS2FontProperties fontProperties = this.fontProperties("Arial", 10, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        CSSResourcesHelpersTest.assertNotNull((Object)result);
        CSSResourcesHelpersTest.assertEquals((String)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (String)result);
    }

    public void testGetCSSValueKeyWhenDefinitionAsFontFamily() throws Exception {
        CSS2FontProperties fontProperties = this.fontProperties(this.addFontDefinitionMarker("symbolicName"), 10, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        CSSResourcesHelpersTest.assertNotNull((Object)result);
        CSSResourcesHelpersTest.assertEquals((String)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (String)result);
    }

    public void testGetCSSValueKeyWhenRgbAsColorValue() throws Exception {
        CSSValueImpl colorValue = this.colorValue("rgb(255,0,0)");
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        CSSResourcesHelpersTest.assertNotNull((Object)result);
        CSSResourcesHelpersTest.assertEquals((String)"rgb(255,0,0)", (String)result);
    }

    public void testGetCSSValueKeyWhenDefinitionAsColorValue() throws Exception {
        CSSValueImpl colorValue = this.colorValue(this.addColorDefinitionMarker("symbolicName"));
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        CSSResourcesHelpersTest.assertNotNull((Object)result);
        CSSResourcesHelpersTest.assertEquals((String)"#symbolicName", (String)result);
    }
}

