/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.e4.ui.css.swt.resources.ResourceByDefinitionKey;
import org.eclipse.e4.ui.css.swt.resources.SWTResourceRegistryKeyFactory;
import org.w3c.dom.css.CSSValue;

public class SWTResourceRegistryKeyFactoryTest
extends CSSSWTHelperTestCase {
    private SWTResourceRegistryKeyFactory factory = new SWTResourceRegistryKeyFactory();

    public void testCreateKeyWhenFontProperty() throws Exception {
        CSS2FontProperties fontProperties = this.fontProperties("Arial", 12, 2);
        Object result = this.factory.createKey((CSSValue)fontProperties);
        SWTResourceRegistryKeyFactoryTest.assertEquals(String.class, result.getClass());
        SWTResourceRegistryKeyFactoryTest.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties), (Object)result);
    }

    public void testCreateKeyWhenColorValue() throws Exception {
        CSSValueImpl colorValue = this.colorValue("red");
        Object result = this.factory.createKey((CSSValue)colorValue);
        SWTResourceRegistryKeyFactoryTest.assertEquals(String.class, result.getClass());
        SWTResourceRegistryKeyFactoryTest.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue), (Object)result);
    }

    public void testCreateKeyWhenFontByDefinition() throws Exception {
        CSS2FontProperties fontProperties = this.fontProperties("#font-by-definition", 12, 2);
        Object result = this.factory.createKey((CSSValue)fontProperties);
        SWTResourceRegistryKeyFactoryTest.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        SWTResourceRegistryKeyFactoryTest.assertEquals((String)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties).toString(), (String)result.toString());
    }

    public void testCreateKeyWhenColorByDefinition() throws Exception {
        CSSValueImpl colorValue = this.colorValue("#color-by-definition");
        Object result = this.factory.createKey((CSSValue)colorValue);
        SWTResourceRegistryKeyFactoryTest.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        SWTResourceRegistryKeyFactoryTest.assertEquals((String)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue).toString(), (String)result.toString());
    }
}

