/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSValue;

public class CSSSWTColorHelperTest
extends CSSSWTHelperTestCase {
    private Display display;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
    }

    public void testGetSWTColor() throws Exception {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("red"), (Display)this.display);
        CSSSWTColorHelperTest.assertNotNull((Object)result);
        CSSSWTColorHelperTest.assertEquals((int)255, (int)result.getRed());
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getBlue());
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getGreen());
    }

    public void testGetSWTColorWhenNotSupportedColorType() throws Exception {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("123213", (short)3), (Display)this.display);
        CSSSWTColorHelperTest.assertNull((Object)result);
    }

    public void testGetSWTColorWhenInvalidColorValue() throws Exception {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("asdsad12"), (Display)this.display);
        CSSSWTColorHelperTest.assertNotNull((Object)result);
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getRed());
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getBlue());
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getGreen());
    }

    public void testGetSWTColorWhenColorFromDefinition() throws Exception {
        this.registerColorProviderWith("org.eclipse.jdt.debug.ui.InDeadlockColor", new RGB(0, 255, 0));
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue(this.addColorDefinitionMarker("org-eclipse-jdt-debug-ui-InDeadlockColor")), (Display)this.display);
        CSSSWTColorHelperTest.assertNotNull((Object)result);
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getRed());
        CSSSWTColorHelperTest.assertEquals((int)0, (int)result.getBlue());
        CSSSWTColorHelperTest.assertEquals((int)255, (int)result.getGreen());
    }
}

