/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.FontData;

public class CSSSWTFontHelperTest
extends CSSSWTHelperTestCase {
    public void testGetFontData() throws Exception {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, 0), (FontData)new FontData());
        CSSSWTFontHelperTest.assertEquals((String)"Times", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)11, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)0, (int)result.getStyle());
    }

    public void testGetFontDataWhenMissingFamilyInCss() throws Exception {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(null, 11, 0), (FontData)new FontData("Courier", 5, 2));
        CSSSWTFontHelperTest.assertEquals((String)"Courier", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)11, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)0, (int)result.getStyle());
    }

    public void testGetFontDataWhenMissingSizeInCss() throws Exception {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Arial", null, 0), (FontData)new FontData("Courier", 5, 2));
        CSSSWTFontHelperTest.assertEquals((String)"Arial", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)5, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)0, (int)result.getStyle());
    }

    public void testGetFontDataWhenMissingStyleInCss() throws Exception {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, null), (FontData)new FontData("Courier", 5, 2));
        CSSSWTFontHelperTest.assertEquals((String)"Times", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)11, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)2, (int)result.getStyle());
    }

    public void testGetFontDataWhenFontFamilyFromDefinition() throws Exception {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 2);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), 10, null), (FontData)new FontData());
        CSSSWTFontHelperTest.assertEquals((String)"Arial", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)10, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)2, (int)result.getStyle());
    }

    public void testGetFontDataWhenFontFamilyAndSizeFromDefinition() throws Exception {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 2);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), null, 0), (FontData)new FontData());
        CSSSWTFontHelperTest.assertEquals((String)"Arial", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)15, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)2, (int)result.getStyle());
    }

    public void testGetFontDataWhenFontFamilySizeAndStyleFromDefinition() throws Exception {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 2);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont")), (FontData)new FontData());
        CSSSWTFontHelperTest.assertEquals((String)"Arial", (String)result.getName());
        CSSSWTFontHelperTest.assertEquals((int)15, (int)result.getHeight());
        CSSSWTFontHelperTest.assertEquals((int)2, (int)result.getStyle());
    }
}

