/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.mockito.Mockito;
import org.w3c.dom.DOMException;

public abstract class CSSSWTHelperTestCase
extends TestCase {
    protected void registerFontProviderWith(String expectedSymbolicName, String family, int size, int style) throws Exception {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)new FontData[]{new FontData(family, size, style)}).when((Object)provider)).getFont(expectedSymbolicName);
        this.registerProvider(provider);
    }

    protected void registerColorProviderWith(String expectedSymbolicName, RGB rgb) throws Exception {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)rgb).when((Object)provider)).getColor(expectedSymbolicName);
        this.registerProvider(provider);
    }

    private void registerProvider(final IColorAndFontProvider provider) throws Exception {
        new CSSActivator(){

            public IColorAndFontProvider getColorAndFontProvider() {
                return provider;
            }
        }.start(null);
    }

    protected CSS2FontProperties fontProperties(String family) throws Exception {
        return this.fontProperties(family, null, null);
    }

    protected CSS2FontProperties fontProperties(String family, Object size, Object style) throws Exception {
        CSS2FontProperties result = (CSS2FontProperties)Mockito.mock(CSS2FontProperties.class);
        ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(family)).when((Object)result)).getFamily();
        if (size != null) {
            ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(size)).when((Object)result)).getSize();
        }
        if (style != null) {
            ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(style)).when((Object)result)).getStyle();
        }
        return result;
    }

    private CSSValueImpl valueImpl(final Object value) {
        if (value != null) {
            return new CSSValueImpl(){

                public String getCssText() {
                    return value.toString();
                }

                public String getStringValue() {
                    return this.getCssText();
                }

                public float getFloatValue(short valueType) throws DOMException {
                    return Float.parseFloat(this.getCssText());
                }
            };
        }
        return null;
    }

    protected CSSValueImpl colorValue(String value) {
        return this.colorValue(value, (short)1);
    }

    protected CSSValueImpl colorValue(String value, short type) {
        CSSValueImpl result = (CSSValueImpl)Mockito.mock(CSSValueImpl.class);
        ((CSSValueImpl)Mockito.doReturn((Object)19).when((Object)result)).getPrimitiveType();
        ((CSSValueImpl)Mockito.doReturn((Object)type).when((Object)result)).getCssValueType();
        ((CSSValueImpl)Mockito.doReturn((Object)value).when((Object)result)).getStringValue();
        ((CSSValueImpl)Mockito.doReturn((Object)value).when((Object)result)).getCssText();
        return result;
    }

    protected String addFontDefinitionMarker(String fontDefinitionId) {
        return "#" + fontDefinitionId;
    }

    protected String addColorDefinitionMarker(String colorDefinitionId) {
        return "#" + colorDefinitionId;
    }
}

