/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EclipsePreferencesHelperTest
extends TestCase {
    public void testAppendOverriddenPropertyName() throws Exception {
        IEclipsePreferences preferences = (IEclipsePreferences)Mockito.spy((Object)new EclipsePreferences());
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        String overriddenPreferences = preferences.get("overriddenByCSS", "");
        EclipsePreferencesHelperTest.assertTrue((boolean)overriddenPreferences.contains(",prop1,"));
        EclipsePreferencesHelperTest.assertTrue((boolean)overriddenPreferences.contains(",prop2,"));
        EclipsePreferencesHelperTest.assertTrue((boolean)overriddenPreferences.contains(",prop3,"));
        ((IEclipsePreferences)Mockito.verify((Object)preferences, (VerificationMode)Mockito.times((int)1))).addPreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
    }

    public void testGetOverriddenPropertyNames() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        List propertyNames = EclipsePreferencesHelper.getOverriddenPropertyNames((IEclipsePreferences)preferences);
        EclipsePreferencesHelperTest.assertEquals((int)3, (int)propertyNames.size());
        EclipsePreferencesHelperTest.assertTrue((boolean)propertyNames.add("prop1"));
        EclipsePreferencesHelperTest.assertTrue((boolean)propertyNames.add("prop2"));
        EclipsePreferencesHelperTest.assertTrue((boolean)propertyNames.add("prop3"));
    }

    public void testRemoveOverriddenPropertyNames() throws Exception {
        IEclipsePreferences preferences = (IEclipsePreferences)Mockito.spy((Object)new EclipsePreferences());
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.removeOverriddenPropertyNames((IEclipsePreferences)preferences);
        EclipsePreferencesHelperTest.assertNull((Object)preferences.get("overriddenByCSS", null));
        ((IEclipsePreferences)Mockito.verify((Object)preferences, (VerificationMode)Mockito.times((int)1))).removePreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
    }

    public void testRemoveOverriddenByCssProperty() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        EclipsePreferencesHelper.removeOverriddenByCssProperty((IEclipsePreferences)preferences, (String)"prop2");
        String overriddenPreferences = preferences.get("overriddenByCSS", "");
        EclipsePreferencesHelperTest.assertTrue((boolean)overriddenPreferences.contains(",prop1,"));
        EclipsePreferencesHelperTest.assertFalse((boolean)overriddenPreferences.contains(",prop2,"));
        EclipsePreferencesHelperTest.assertTrue((boolean)overriddenPreferences.contains(",prop3,"));
    }
}

