/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import junit.framework.TestCase;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PreferenceOverriddenByCssChangeListenerTest
extends TestCase {
    public void testPreferenceChangeEvent() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        preferences.put("overriddenByCSS", ",name,");
        IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)preferences, "name", (Object)"oldValue", (Object)"newValue");
        PreferenceOverriddenByCssChangeListenerTestable preferenceChangeListener = (PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.spy((Object)((Object)new PreferenceOverriddenByCssChangeListenerTestable())));
        preferenceChangeListener.preferenceChange(event);
        ((PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.verify((Object)((Object)preferenceChangeListener), (VerificationMode)Mockito.times((int)1)))).removeOverriddenByCssProperty(event);
    }

    public void testPreferenceChangeEventWhenAddPropertyEvent() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        preferences.put("overriddenByCSS", ",name,");
        IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)preferences, "name", null, (Object)"newValue");
        PreferenceOverriddenByCssChangeListenerTestable preferenceChangeListener = (PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.spy((Object)((Object)new PreferenceOverriddenByCssChangeListenerTestable())));
        preferenceChangeListener.preferenceChange(event);
        ((PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.verify((Object)((Object)preferenceChangeListener), (VerificationMode)Mockito.never()))).removeOverriddenByCssProperty(event);
    }

    public void testPreferenceChangeEventWhenRemovePropertyEvent() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        preferences.put("overriddenByCSS", ",name,");
        IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)preferences, "name", (Object)"oldValue", null);
        PreferenceOverriddenByCssChangeListenerTestable preferenceChangeListener = (PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.spy((Object)((Object)new PreferenceOverriddenByCssChangeListenerTestable())));
        preferenceChangeListener.preferenceChange(event);
        ((PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.verify((Object)((Object)preferenceChangeListener), (VerificationMode)Mockito.never()))).removeOverriddenByCssProperty(event);
    }

    public void testPreferenceChangeEventWhenModifyPropertyEventButPropertyIsNotOverriddenByCss() throws Exception {
        EclipsePreferences preferences = new EclipsePreferences();
        IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)preferences, "name", (Object)"oldValue", (Object)"newValue");
        PreferenceOverriddenByCssChangeListenerTestable preferenceChangeListener = (PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.spy((Object)((Object)new PreferenceOverriddenByCssChangeListenerTestable())));
        preferenceChangeListener.preferenceChange(event);
        ((PreferenceOverriddenByCssChangeListenerTestable)((Object)Mockito.verify((Object)((Object)preferenceChangeListener), (VerificationMode)Mockito.never()))).removeOverriddenByCssProperty(event);
    }

    public static class PreferenceOverriddenByCssChangeListenerTestable
    extends EclipsePreferencesHelper.PreferenceOverriddenByCssChangeListener {
        public void removeOverriddenByCssProperty(IEclipsePreferences.PreferenceChangeEvent event) {
        }
    }
}

