/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class Bug419482Test
extends CSSSWTTestCase {
    private static final RGB RGB_BLUE = new RGB(0, 0, 255);
    private static final RGB RGB_RED = new RGB(255, 0, 0);
    private CSSEngine engine;
    private ToolBar toolbar1;
    private ToolBar toolbar2;
    private ToolBar toolbar3;

    public void testTwoLevelsWildcard() throws Exception {
        String cssString = "Shell > * > * { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)rgb);
    }

    public void testOneLevelWildcardOneSpecific() throws Exception {
        String cssString = "Shell > * > Label { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Bug419482Test.assertEquals((Object)RGB_RED, (Object)rgb);
    }

    public void testDescendentsWildcard() throws Exception {
        String cssString = "Shell * { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)rgb);
    }

    public void testDescendentsSpecific() throws Exception {
        String cssString = "Shell Label { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Bug419482Test.assertEquals((Object)RGB_RED, (Object)rgb);
    }

    private Label createTestLabel(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(composite, 0);
        labelToTest.setText("Some label text");
        this.engine.applyStyles((Object)labelToTest, true);
        return labelToTest;
    }

    public void testOriginalBugReport() {
        String css = "Shell, Shell > *, Shell > * > * {\n    background-color: red;\n}\nToolBar {\n    background-color: blue;\n}";
        Display display = Display.getDefault();
        this.engine = this.createEngine(css, display);
        Shell shell = this.createShellWithToolbars(display);
        this.engine.applyStyles((Object)shell, true);
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)this.toolbar1.getBackground().getRGB());
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)this.toolbar2.getBackground().getRGB());
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)this.toolbar3.getBackground().getRGB());
    }

    public void testOriginalBugReportDifferentOrder() {
        String css = "ToolBar {\n    background-color: blue;\n}Shell, Shell > *, Shell > * > * {\n    background-color: red;\n}\n";
        Display display = Display.getDefault();
        this.engine = this.createEngine(css, display);
        Shell shell = this.createShellWithToolbars(display);
        this.engine.applyStyles((Object)shell, true);
        Bug419482Test.assertEquals((Object)RGB_RED, (Object)this.toolbar1.getBackground().getRGB());
        Bug419482Test.assertEquals((Object)RGB_RED, (Object)this.toolbar2.getBackground().getRGB());
        Bug419482Test.assertEquals((Object)RGB_BLUE, (Object)this.toolbar3.getBackground().getRGB());
    }

    private Shell createShellWithToolbars(Display display) {
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new RowLayout(512));
        this.toolbar1 = new ToolBar((Composite)shell, 2048);
        Composite composite1 = new Composite((Composite)shell, 0);
        composite1.setLayout((Layout)new RowLayout(512));
        this.toolbar2 = new ToolBar(composite1, 2048);
        Composite composite2 = new Composite(composite1, 0);
        composite2.setLayout((Layout)new RowLayout(512));
        this.toolbar3 = new ToolBar(composite2, 2048);
        return shell;
    }
}

