/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CSSSWTTestCase
extends TestCase {
    public CSSEngine createEngine(String styleSheet, Display display) {
        CSSSWTEngineImpl engine = new CSSSWTEngineImpl(display);
        engine.setErrorHandler(new CSSErrorHandler(){

            public void error(Exception e) {
                CSSSWTTestCase.fail((String)e.getMessage());
            }
        });
        try {
            engine.parseStyleSheet((Reader)new StringReader(styleSheet));
        }
        catch (IOException e) {
            CSSSWTTestCase.fail((String)e.getMessage());
        }
        return engine;
    }

    public void clearAndApply(CSSEngine engine, Widget widget, String styleSheet) {
        engine.reset();
        try {
            engine.parseStyleSheet((Reader)new StringReader(styleSheet));
        }
        catch (IOException e) {
            CSSSWTTestCase.fail((String)e.getMessage());
        }
        engine.applyStyles((Object)widget, true, true);
    }

    public static void assertEquals(int[] expected, int[] actual) {
        CSSSWTTestCase.assertEquals((int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            CSSSWTTestCase.assertEquals((int)expected[i], (int)actual[i]);
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                shell.dispose();
                ++n2;
            }
        }
        super.tearDown();
    }
}

