/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.mockito.Mockito;

public class ColorDefinitionTest
extends CSSSWTTestCase {
    private Display display;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
    }

    public void testColorDefinition() throws Exception {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertEquals((String)"name", (String)definition.getName());
        ColorDefinitionTest.assertEquals((String)"categoryId", (String)definition.getCategoryId());
        ColorDefinitionTest.assertTrue((boolean)definition.getDescription().startsWith("description"));
        ColorDefinitionTest.assertTrue((boolean)definition.isOverridden());
    }

    public void testColorDefinitionWhenNameCategoryIdAndDescriptionOverridden() throws Exception {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green;label:'nameOverridden'; category:'#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertEquals((String)"nameOverridden", (String)definition.getName());
        ColorDefinitionTest.assertEquals((String)"categoryIdOverridden", (String)definition.getCategoryId());
        ColorDefinitionTest.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        ColorDefinitionTest.assertTrue((boolean)definition.isOverridden());
    }

    public void testColorDefinitionWhenDefinitionStylesheetNotFound() throws Exception {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("color definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        ColorDefinitionTest.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        ColorDefinitionTest.assertFalse((boolean)definition.isOverridden());
    }

    public void testWidgetWithColorDefinitionAsBackgroundColor() throws Exception {
        this.registerColorProviderWith("ACTIVE_HYPERLINK_COLOR", new RGB(255, 0, 0));
        CSSEngine engine = this.createEngine("Label {background-color: '#ACTIVE_HYPERLINK_COLOR'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        label.setText("Some label text");
        engine.applyStyles((Object)label, true);
        ColorDefinitionTest.assertEquals((Object)new RGB(255, 0, 0), (Object)label.getBackground().getRGB());
        shell.dispose();
    }

    private ColorDefinition colorDefinition(String uniqueId, String name, String categoryId, String description) {
        return new ColorDefinition(name, uniqueId, "defaultsTo", "black", categoryId, true, description, "pluginId");
    }

    private void registerColorProviderWith(final String symbolicName, final RGB rgb) throws Exception {
        new CSSActivator(){

            public IColorAndFontProvider getColorAndFontProvider() {
                IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
                ((IColorAndFontProvider)Mockito.doReturn((Object)rgb).when((Object)provider)).getColor(symbolicName);
                return provider;
            }
        }.start(null);
    }
}

