/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.mockito.Mockito;

public class FontDefinitionTest
extends CSSSWTTestCase {
    private Display display;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
    }

    public void testFontDefinition() throws Exception {
        CSSEngine engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        FontDefinitionTest.assertNull((Object)definition.getValue());
        FontDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        FontDefinitionTest.assertNotNull((Object)definition.getValue());
        FontDefinitionTest.assertEquals((String)"Times", (String)definition.getValue()[0].getName());
        FontDefinitionTest.assertEquals((int)12, (int)definition.getValue()[0].getHeight());
        FontDefinitionTest.assertEquals((int)2, (int)definition.getValue()[0].getStyle());
        FontDefinitionTest.assertEquals((String)"categoryId", (String)definition.getCategoryId());
        FontDefinitionTest.assertEquals((String)"name", (String)definition.getName());
        FontDefinitionTest.assertTrue((boolean)definition.getDescription().startsWith("description"));
        FontDefinitionTest.assertTrue((boolean)definition.isOverridden());
    }

    public void testFontDefinitionWhenNameCategoryIdAndDescriptionOverridden() throws Exception {
        CSSEngine engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic; label:'nameOverridden'; category: '#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        FontDefinitionTest.assertNull((Object)definition.getValue());
        FontDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        FontDefinitionTest.assertNotNull((Object)definition.getValue());
        FontDefinitionTest.assertEquals((String)"Times", (String)definition.getValue()[0].getName());
        FontDefinitionTest.assertEquals((int)12, (int)definition.getValue()[0].getHeight());
        FontDefinitionTest.assertEquals((int)2, (int)definition.getValue()[0].getStyle());
        FontDefinitionTest.assertEquals((String)"categoryIdOverridden", (String)definition.getCategoryId());
        FontDefinitionTest.assertEquals((String)"nameOverridden", (String)definition.getName());
        FontDefinitionTest.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        FontDefinitionTest.assertTrue((boolean)definition.isOverridden());
    }

    public void testFontDefinitionWhenDefinitionStylesheetNotFound() throws Exception {
        CSSEngine engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;}", this.display);
        FontDefinition definition = this.fontDefinition("font definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        FontDefinitionTest.assertNull((Object)definition.getValue());
        FontDefinitionTest.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        FontDefinitionTest.assertNull((Object)definition.getValue());
        FontDefinitionTest.assertFalse((boolean)definition.isOverridden());
    }

    public void testWidgetWithFontDefinitionAsFontFamily() throws Exception {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", new FontData("Times", 12, 2));
        CSSEngine engine = this.createEngine("Label {font-family: '#org-eclipse-jface-bannerfont'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        Font font = new Font((Device)this.display, "Arial", 9, 0);
        label.setFont(font);
        label.setText("Some label text");
        engine.applyStyles((Object)label, true);
        FontDefinitionTest.assertEquals((String)"Times", (String)label.getFont().getFontData()[0].getName());
        FontDefinitionTest.assertEquals((int)12, (int)label.getFont().getFontData()[0].getHeight());
        FontDefinitionTest.assertEquals((int)2, (int)label.getFont().getFontData()[0].getStyle());
        shell.dispose();
        font.dispose();
    }

    private FontDefinition fontDefinition(String uniqueId, String name, String categoryId, String description) {
        return new FontDefinition(new FontDefinition(name, uniqueId, "defaultsId", "value", categoryId, true, description), new FontData[]{new FontData("Arial", 10, 0)});
    }

    private void registerFontProviderWith(final String symbolicName, final FontData fontData) throws Exception {
        new CSSActivator(){

            public IColorAndFontProvider getColorAndFontProvider() {
                IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
                ((IColorAndFontProvider)Mockito.doReturn((Object)new FontData[]{fontData}).when((Object)provider)).getFont(symbolicName);
                return provider;
            }
        }.start(null);
    }
}

