/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.HashSet;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ShellTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Shell createTestShell(String styleSheet) {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    public void testColor() throws Exception {
        Shell shellToTest = this.createTestShell("Shell { background-color: #FF0000; color: #0000FF }");
        ShellTest.assertEquals((Object)RED, (Object)shellToTest.getBackground().getRGB());
        ShellTest.assertEquals((Object)BLUE, (Object)shellToTest.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Shell shellToTest = this.createTestShell("Shell { font: Verdana 16px }");
        ShellTest.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        ShellTest.assertEquals((String)"Verdana", (String)fontData.getName());
        ShellTest.assertEquals((int)16, (int)fontData.getHeight());
        ShellTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Shell shellToTest = this.createTestShell("Shell { font: Arial 12px; font-weight: bold }");
        ShellTest.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        ShellTest.assertEquals((String)"Arial", (String)fontData.getName());
        ShellTest.assertEquals((int)12, (int)fontData.getHeight());
        ShellTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Shell shellToTest = this.createTestShell("Shell { font-style: italic }");
        ShellTest.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void test375069ChildShellDifferentiation() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell.parent { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        engine.applyStyles((Object)parent, true);
        engine.applyStyles((Object)child, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
        ShellTest.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        ShellTest.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    public void test375069AllShell() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        engine.applyStyles((Object)parent, true);
        engine.applyStyles((Object)child, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
        ShellTest.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testShellParentage() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell[parentage='parent'] { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        WidgetElement.setID((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setID((Widget)child, (String)"child");
        parent.open();
        child.open();
        engine.applyStyles((Object)parent, true);
        engine.applyStyles((Object)child, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertNotSame((Object)2, (Object)fontData.getStyle());
        ShellTest.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testShellUnparentedPseudoelement() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell:swt-unparented { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        engine.applyStyles((Object)parent, true);
        engine.applyStyles((Object)child, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
        ShellTest.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        ShellTest.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    public void testShellParentedPseudoelement() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell:swt-parented { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        engine.applyStyles((Object)parent, true);
        engine.applyStyles((Object)child, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertNotSame((Object)2, (Object)fontData.getStyle());
        ShellTest.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testSwtDataClassAttribute() throws Exception {
        Display display = Display.getDefault();
        CSSEngine engine = this.createEngine("Shell[swt-data-class ~= 'java.util.HashSet'] { font-style: italic; }", display);
        Shell parent = new Shell(display, 0);
        parent.setData(new HashSet());
        parent.open();
        engine.applyStyles((Object)parent, true);
        ShellTest.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testBackgroundMode() throws Exception {
        Shell shellToTest = this.createTestShell("Shell { swt-background-mode: force; }");
        ShellTest.assertEquals((int)2, (int)shellToTest.getBackgroundMode());
    }
}

