/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ThemeTest
extends CSSSWTTestCase {
    private BundleContext context;
    private ServiceRegistration<EventHandler> themeListenerRegistration;
    private ServiceReference<IThemeManager> themeManagerReference;

    public void setUp() throws Exception {
        Bundle b = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        ThemeTest.assertNotNull((String)"Not running in an OSGi environment", (Object)b);
        this.context = b.getBundleContext();
        ThemeTest.assertNotNull((String)"Not running in an OSGi environment", (Object)b);
        this.themeManagerReference = this.context.getServiceReference(IThemeManager.class);
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.themeListenerRegistration.unregister();
        super.tearDown();
    }

    public void testThemeChangeNotification() throws Exception {
        final Display display = Display.getDefault();
        final IThemeEngine themer = this.getThemeEngine(display);
        final boolean[] success = new boolean[1];
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged");
        this.themeListenerRegistration = this.context.registerService(EventHandler.class, (Object)new EventHandler(){

            public void handleEvent(Event event) {
                ITheme theme = (ITheme)event.getProperty("theme");
                success[0] = "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged".equals(event.getTopic()) && theme != null && theme.getId().equals("test") && event.getProperty("device") == display && event.getProperty("themeEngine") == themer && event.getProperty("restore") == Boolean.TRUE;
            }
        }, properties);
        ThemeTest.assertFalse((boolean)success[0]);
        themer.setTheme((ITheme)new Theme("test", "Test"), true);
        ThemeTest.assertTrue((boolean)success[0]);
    }

    private IThemeEngine getThemeEngine(Display display) {
        IThemeManager manager = (IThemeManager)this.context.getService(this.themeManagerReference);
        ThemeTest.assertNotNull((String)"Theme manager service not available", (Object)manager);
        return manager.getEngineForDisplay(display);
    }
}

