/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.tests.application.UITest;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventBrokerTest
extends UITest {
    private static final String TEST_TOPIC = "test/EventBrokerTest";
    private AtomicInteger seen;
    private IEclipseContext context;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.seen = new AtomicInteger(0);
        this.context = this.application.getContext().createChild(((Object)((Object)this)).getClass().getName());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.context.dispose();
    }

    public void testPublish() {
        IEventBroker eb = (IEventBroker)this.context.get(IEventBroker.class);
        EventBrokerTest.assertNotNull((Object)eb);
        eb.subscribe(TEST_TOPIC, new EventHandler(){

            public void handleEvent(Event event) {
                if (EventBrokerTest.TEST_TOPIC.equals(event.getTopic())) {
                    EventBrokerTest.this.seen.incrementAndGet();
                }
            }
        });
        eb.send(TEST_TOPIC, new Object());
        EventBrokerTest.assertEquals((int)1, (int)this.seen.get());
    }

    public void testUnsubscribeOnDispose() {
        IEventBroker publisher = (IEventBroker)this.context.get(IEventBroker.class);
        EventBrokerTest.assertNotNull((Object)publisher);
        IEclipseContext child = this.context.createChild();
        IEventBroker subscriber = (IEventBroker)child.get(IEventBroker.class);
        EventBrokerTest.assertNotNull((Object)subscriber);
        subscriber.subscribe(TEST_TOPIC, new EventHandler(){

            public void handleEvent(Event event) {
                if (EventBrokerTest.TEST_TOPIC.equals(event.getTopic())) {
                    EventBrokerTest.this.seen.incrementAndGet();
                }
            }
        });
        publisher.send(TEST_TOPIC, new Object());
        EventBrokerTest.assertEquals((int)1, (int)this.seen.get());
        child.dispose();
        publisher.send(TEST_TOPIC, new Object());
        EventBrokerTest.assertEquals((String)"event broker did not properly unsubscribe on dispose", (int)1, (int)this.seen.get());
    }

    public void testMultipleSubscriptions() {
        IEventBroker eb = (IEventBroker)this.context.get(IEventBroker.class);
        EventBrokerTest.assertNotNull((Object)eb);
        EventHandler handler = new EventHandler(){

            public void handleEvent(Event event) {
                if (EventBrokerTest.TEST_TOPIC.equals(event.getTopic())) {
                    EventBrokerTest.this.seen.incrementAndGet();
                }
            }
        };
        eb.subscribe(TEST_TOPIC, handler);
        eb.subscribe("*", handler);
        eb.send(TEST_TOPIC, new Object());
        EventBrokerTest.assertEquals((int)2, (int)this.seen.get());
        eb.unsubscribe(handler);
        eb.send(TEST_TOPIC, new Object());
        EventBrokerTest.assertEquals((String)"subscription was not removed", (int)2, (int)this.seen.get());
    }
}

