/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ModelRobustnessTest
extends TestCase {
    public void testLoadingInvalidContainments() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/InvalidContainment.e4xmi", (boolean)true);
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = null;
        try {
            resource = set.getResource(uri, true);
            ModelRobustnessTest.fail((String)"This should have thrown an exception");
        }
        catch (Exception exception) {
            resource = set.getResource(uri, false);
        }
        ModelRobustnessTest.assertNotNull((Object)resource);
        ModelRobustnessTest.assertEquals(E4XMIResource.class, resource.getClass());
        ModelRobustnessTest.assertEquals((int)1, (int)resource.getContents().size());
        MApplication app = (MApplication)resource.getContents().get(0);
        ModelRobustnessTest.assertEquals((int)1, (int)app.getChildren().size());
        MWindow w = (MWindow)app.getChildren().get(0);
        ModelRobustnessTest.assertEquals((String)"window1", (String)w.getElementId());
        ModelRobustnessTest.assertEquals((int)2, (int)w.getChildren().size());
        MPartStack stack = (MPartStack)w.getChildren().get(0);
        ModelRobustnessTest.assertEquals((String)"window1.partstack1", (String)stack.getElementId());
        ModelRobustnessTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelRobustnessTest.assertEquals((String)"window1.partstack1.part1", (String)((MStackElement)stack.getChildren().get(0)).getElementId());
        ModelRobustnessTest.assertEquals((String)"window1.partstack1.inputpart1", (String)((MStackElement)stack.getChildren().get(1)).getElementId());
        stack = (MPartStack)w.getChildren().get(1);
        ModelRobustnessTest.assertEquals((String)"window1.partstack2", (String)stack.getElementId());
        ModelRobustnessTest.assertEquals((int)1, (int)stack.getChildren().size());
        ModelRobustnessTest.assertEquals((String)"window1.partstack2.part1", (String)((MStackElement)stack.getChildren().get(0)).getElementId());
    }

    public void testAddingInvalidElements() {
        MApplication app = MApplicationFactory.INSTANCE.createApplication();
        List l = app.getChildren();
        l.add(MBasicFactory.INSTANCE.createWindow());
        try {
            l.add(MBasicFactory.INSTANCE.createPart());
            ModelRobustnessTest.fail((String)"The adding of this should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayStoreException arrayStoreException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        l.add(MBasicFactory.INSTANCE.createWindow());
        ModelRobustnessTest.assertEquals((int)2, (int)l.size());
    }
}

