/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.tests.application.HeadlessStartupTest;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceHandlerTest
extends HeadlessStartupTest {
    private ServiceTracker locationTracker;

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            BundleContext context = FrameworkUtil.getBundle(ResourceHandlerTest.class).getBundleContext();
            Filter filter = null;
            try {
                filter = context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.locationTracker = new ServiceTracker(context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    private ResourceHandler createHandler(URI uri) {
        IEclipseContext localContext = this.applicationContext.createChild();
        localContext.set("instanceLocation", (Object)this.getInstanceLocation());
        localContext.set("persistState", (Object)Boolean.TRUE);
        localContext.set("clearPersistedState", (Object)Boolean.TRUE);
        localContext.set("deltaRestore", (Object)Boolean.TRUE);
        localContext.set("initialWorkbenchModelURI", (Object)uri);
        return (ResourceHandler)ContextInjectionFactory.make(ResourceHandler.class, (IEclipseContext)localContext);
    }

    public void testModelProcessor() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        MApplication application = (MApplication)resource.getContents().get(0);
        ResourceHandlerTest.assertNotNull((Object)application);
        ResourceHandlerTest.assertEquals((int)2, (int)application.getChildren().size());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedWindow", (String)((MWindow)application.getChildren().get(1)).getElementId());
        ResourceHandlerTest.assertEquals((String)"_w4fQ8HVHEd-aXt9fFntEtw", (String)((E4XMIResource)resource).getID((EObject)application.getChildren().get(1)));
        ResourceHandlerTest.assertEquals((String)"_rdlLgJQUEd-6X_lmWgGEDA", (String)((E4XMIResource)resource).getID((EObject)((MWindow)application.getChildren().get(1)).getChildren().get(0)));
        ResourceHandlerTest.assertEquals((String)"platform:/plugin/org.eclipse.e4.ui.tests", (String)((MWindow)application.getChildren().get(1)).getContributorURI());
        ResourceHandlerTest.assertEquals((String)"platform:/plugin/org.eclipse.e4.ui.tests", (String)((MWindowElement)((MWindow)application.getChildren().get(1)).getChildren().get(0)).getContributorURI());
        if (application.getHandlers().size() > 2) {
            String check = "bundleclass://org.eclipse.e4.tools.emf.liveeditor/org.eclipse.e4.tools.emf.liveeditor.OpenLiveDialogHandler";
            if (check.equals(((MHandler)application.getHandlers().get(0)).getContributionURI())) {
                application.getHandlers().remove(0);
            } else if (check.equals(((MHandler)application.getHandlers().get(1)).getContributionURI())) {
                application.getHandlers().remove(1);
            }
        }
        ResourceHandlerTest.assertTrue((application.getHandlers().size() > 0 ? 1 : 0) != 0);
        ResourceHandlerTest.assertSame(application.getCommands().get(0), (Object)((MHandler)application.getHandlers().get(0)).getCommand());
        ResourceHandlerTest.assertEquals((int)2, (int)((MCommand)application.getCommands().get(0)).getParameters().size());
        ResourceHandlerTest.assertEquals((int)1, (int)((MWindow)application.getChildren().get(1)).getVariables().size());
        ResourceHandlerTest.assertNotNull((Object)((MWindow)application.getChildren().get(0)).getMainMenu());
        ResourceHandlerTest.assertEquals((int)8, (int)((MWindow)application.getChildren().get(0)).getChildren().size());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedPosFirst", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(0)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedPos1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(1)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedBeforePart1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(2)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedAfterPart1", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(4)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedBeforePart2", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(5)).getElementId());
        ResourceHandlerTest.assertEquals((String)"fragment.contributedAfterPart2", (String)((MWindowElement)((MWindow)application.getChildren().get(0)).getChildren().get(7)).getElementId());
    }
}

