/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerUIElementTest
extends ModelReconcilerTest {
    private void testUIElement_ToBeRendered(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setToBeRendered(before);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setToBeRendered(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((boolean)before, (boolean)part.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((boolean)after, (boolean)part.isToBeRendered());
    }

    public void testUIElement_ToBeRendered_TrueTrue() {
        this.testUIElement_ToBeRendered(true, true);
    }

    public void testUIElement_ToBeRendered_TrueFalse() {
        this.testUIElement_ToBeRendered(true, false);
    }

    public void testUIElement_ToBeRendered_FalseTrue() {
        this.testUIElement_ToBeRendered(false, true);
    }

    public void testUIElement_ToBeRendered_FalseFalse() {
        this.testUIElement_ToBeRendered(false, false);
    }

    private void testUIElement_Visible(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setVisible(before);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setVisible(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((boolean)before, (boolean)part.isVisible());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((boolean)after, (boolean)part.isVisible());
    }

    public void testUIElement_Visible_TrueTrue() {
        this.testUIElement_Visible(true, true);
    }

    public void testUIElement_Visible_TrueFalse() {
        this.testUIElement_Visible(true, false);
    }

    public void testUIElement_Visible_FalseTrue() {
        this.testUIElement_Visible(false, true);
    }

    public void testUIElement_Visible_FalseFalse() {
        this.testUIElement_Visible(false, false);
    }

    public void testUIElement_Visible_Unmodified() {
        boolean defaultValue = (Boolean)UiPackageImpl.eINSTANCE.getUIElement_ToBeRendered().getDefaultValue();
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setToBeRendered(!defaultValue);
        part.setLabel("name");
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setLabel("newName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((!defaultValue ? 1 : 0) != 0, (boolean)part.isToBeRendered());
        ModelReconcilerUIElementTest.assertEquals((String)"name", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((!defaultValue ? 1 : 0) != 0, (boolean)part.isToBeRendered());
        ModelReconcilerUIElementTest.assertEquals((String)"newName", (String)part.getLabel());
    }

    private void testUIElement_Widget(Object before, Object after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setWidget(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setWidget(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        before = window.getWidget();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((Object)before, (Object)window.getWidget());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((Object)before, (Object)window.getWidget());
    }

    public void testUIElement_Widget_NullNull() {
        this.testUIElement_Widget(null, null);
    }

    public void testUIElement_Widget_NullObject() {
        this.testUIElement_Widget(null, new Object());
    }

    public void testUIElement_Widget_ObjectNull() {
        this.testUIElement_Widget(new Object(), null);
    }

    public void testUIElement_Widget_ObjectObject() {
        this.testUIElement_Widget(new Object(), new Object());
    }

    public void testUIElement_ContainerData_Unmodified() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        window.setTooltip("toolTip");
        window.setContainerData("baseData");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setContainerData("changedData");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerUIElementTest.assertEquals((String)"toolTip", (String)window.getTooltip());
        ModelReconcilerUIElementTest.assertEquals((String)"name", (String)window.getLabel());
        ModelReconcilerUIElementTest.assertEquals((String)"baseData", (String)window.getContainerData());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((String)"toolTip", (String)window.getTooltip());
        ModelReconcilerUIElementTest.assertEquals((String)"name", (String)window.getLabel());
        ModelReconcilerUIElementTest.assertEquals((String)"changedData", (String)window.getContainerData());
    }

    private void testUIElement_ContainerDataUnchanged(String containerData) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setContainerData(containerData);
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        this.saveModel();
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((String)containerData, (String)window.getContainerData());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((String)containerData, (String)window.getContainerData());
    }

    public void testUIElement_ContainerDataUnchanged_Null() {
        this.testUIElement_ContainerDataUnchanged(null);
    }

    public void testUIElement_ContainerDataUnchanged_Empty() {
        this.testUIElement_ContainerDataUnchanged("");
    }

    public void testUIElement_ContainerDataUnchanged_String() {
        this.testUIElement_ContainerDataUnchanged("newData");
    }

    private void testUIElement_ContainerData(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setContainerData(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setContainerData(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((String)before, (String)window.getContainerData());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((String)after, (String)window.getContainerData());
    }

    public void testUIElement_ContainerData_NullNull() {
        this.testUIElement_ContainerData(null, null);
    }

    public void testUIElement_ContainerData_NullEmpty() {
        this.testUIElement_ContainerData(null, "");
    }

    public void testUIElement_ContainerData_NullString() {
        this.testUIElement_ContainerData(null, "newData");
    }

    public void testUIElement_ContainerData_EmptyNull() {
        this.testUIElement_ContainerData("", null);
    }

    public void testUIElement_ContainerData_EmptyEmpty() {
        this.testUIElement_ContainerData("", "");
    }

    public void testUIElement_ContainerData_EmptyString() {
        this.testUIElement_ContainerData("", "newData");
    }

    public void testUIElement_ContainerData_StringNull() {
        this.testUIElement_ContainerData("newData", null);
    }

    public void testUIElement_ContainerData_StringEmpty() {
        this.testUIElement_ContainerData("newData", "");
    }

    public void testUIElement_ContainerData_StringStringUnchanged() {
        this.testUIElement_ContainerData("newData", "newData");
    }

    public void testUIElement_ContainerData_StringStringChanged() {
        this.testUIElement_ContainerData("newData", "newData2");
    }

    private void testUIElement_Renderer(Object before, Object after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setRenderer(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setRenderer(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        before = window.getRenderer();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((Object)before, (Object)window.getRenderer());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((Object)before, (Object)window.getRenderer());
    }

    public void testUIElement_Renderer_NullNull() {
        this.testUIElement_Renderer(null, null);
    }

    public void testUIElement_Renderer_NullObject() {
        this.testUIElement_Renderer(null, new Object());
    }

    public void testUIElement_Renderer_ObjectNull() {
        this.testUIElement_Renderer(new Object(), null);
    }

    public void testUIElement_Renderer_ObjectObject() {
        this.testUIElement_Renderer(new Object(), new Object());
    }

    public void testUIElement_VisibleWhen() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MCoreExpression expression = UiFactoryImpl.eINSTANCE.createCoreExpression();
        expression.setCoreExpressionId("id");
        window.setVisibleWhen((MExpression)expression);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals(null, (Object)window.getVisibleWhen());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertTrue((boolean)(window.getVisibleWhen() instanceof MCoreExpression));
        expression = (MCoreExpression)window.getVisibleWhen();
        ModelReconcilerUIElementTest.assertEquals((String)"id", (String)expression.getCoreExpressionId());
    }

    public void testUIElement_CurSharedRef_Set() {
        MApplication application = this.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        MPlaceholder placeholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        window.getSharedElements().add(part);
        placeholder.setRef((MUIElement)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setCurSharedRef(placeholder);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        perspectiveStack = (MPerspectiveStack)window.getChildren().get(0);
        perspective = (MPerspective)perspectiveStack.getChildren().get(0);
        placeholder = (MPlaceholder)perspective.getChildren().get(0);
        part = (MPart)window.getSharedElements().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)perspectiveStack, window.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)perspectiveStack.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)perspective, perspectiveStack.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)perspective.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)placeholder, perspective.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)window.getSharedElements().size());
        ModelReconcilerUIElementTest.assertEquals((Object)part, window.getSharedElements().get(0));
        ModelReconcilerUIElementTest.assertEquals((Object)part, (Object)placeholder.getRef());
        ModelReconcilerUIElementTest.assertNull((Object)part.getCurSharedRef());
        this.applyAll(deltas);
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)window, application.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)perspectiveStack, window.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)perspectiveStack.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)perspective, perspectiveStack.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)perspective.getChildren().size());
        ModelReconcilerUIElementTest.assertEquals((Object)placeholder, perspective.getChildren().get(0));
        ModelReconcilerUIElementTest.assertEquals((int)1, (int)window.getSharedElements().size());
        ModelReconcilerUIElementTest.assertEquals((Object)part, window.getSharedElements().get(0));
        ModelReconcilerUIElementTest.assertEquals((Object)part, (Object)placeholder.getRef());
        ModelReconcilerUIElementTest.assertNull((Object)part.getCurSharedRef());
    }
}

