/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class MWindowTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void testCreateWindow() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        MWindowTest.assertEquals((String)"MyWindow", (String)((Shell)topWidget).getText());
        MWindowTest.assertEquals((Object)topWidget, (Object)this.appContext.get("activeShell"));
    }

    public void testWindowVisibility() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertTrue((boolean)shell.getVisible());
        window.setVisible(false);
        MWindowTest.assertTrue((!shell.getVisible() ? 1 : 0) != 0);
        window.setVisible(true);
        MWindowTest.assertTrue((boolean)shell.getVisible());
    }

    public void testWindowInvisibleCreate() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        window.setVisible(false);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertTrue((!shell.getVisible() ? 1 : 0) != 0);
    }

    public void testCreateView() {
        MWindow window = this.createWindowWithOneView();
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        MWindowTest.assertEquals((int)1, (int)folder.getItemCount());
        Control c = folder.getItem(0).getControl();
        MWindowTest.assertTrue((boolean)(c instanceof Composite));
        Control[] viewPart = ((Composite)c).getChildren();
        MWindowTest.assertEquals((int)1, (int)viewPart.length);
        MWindowTest.assertTrue((boolean)(viewPart[0] instanceof Tree));
    }

    public void testContextChildren() {
        MWindow window = this.createWindowWithOneView();
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
        IEclipseContext child = this.appContext.getActiveChild();
        MWindowTest.assertNotNull((Object)child);
        MWindowTest.assertEquals((Object)window.getContext(), (Object)child);
        MPart modelPart = this.getContributedPart(window);
        MWindowTest.assertNotNull((Object)modelPart);
        MWindowTest.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
        AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getRenderer();
        factory.activate(modelPart);
        IEclipseContext next = child.getActiveChild();
        while (next != null) {
            child = next;
            if ((next = child.getActiveChild()) != child) continue;
            MWindowTest.fail((String)"Cycle detected in part context");
            break;
        }
        MWindowTest.assertFalse((window.getContext() == child ? 1 : 0) != 0);
        MPart contextPart = (MPart)child.get(MPart.class.getName());
        MWindowTest.assertNotNull((Object)contextPart);
        MWindowTest.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
    }

    public void testCreateMenu() {
        MWindow window = this.createWindowWithOneViewAndMenu();
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)window.getMainMenu().getWidget()).getData()).updateAll(true);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Menu menuBar = shell.getMenuBar();
        MWindowTest.assertNotNull((Object)menuBar);
        MWindowTest.assertEquals((int)1, (int)menuBar.getItemCount());
        MenuItem fileItem = menuBar.getItem(0);
        MWindowTest.assertEquals((String)"File", (String)fileItem.getText());
        Menu fileMenu = fileItem.getMenu();
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        MMenu mainMenu = window.getMainMenu();
        MMenu modelFileMenu = (MMenu)mainMenu.getChildren().get(0);
        MMenuItem item2Model = (MMenuItem)modelFileMenu.getChildren().get(0);
        item2Model.setToBeRendered(false);
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)1, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        item2Model.setToBeRendered(true);
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
    }

    public void testWindow_Name() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setLabel("windowName");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertNotNull((Object)widget);
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((String)shell.getText(), (String)window.getLabel());
        MWindowTest.assertEquals((String)"windowName", (String)shell.getText());
        window.setLabel("windowName2");
        MWindowTest.assertEquals((String)shell.getText(), (String)window.getLabel());
        MWindowTest.assertEquals((String)"windowName2", (String)shell.getText());
    }

    public void TODOtestWindow_X() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        MWindowTest.assertEquals((int)window.getX(), (int)bounds.x);
        MWindowTest.assertEquals((int)200, (int)bounds.x);
        window.setX(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        MWindowTest.assertEquals((int)300, (int)window.getX());
        MWindowTest.assertEquals((int)window.getX(), (int)bounds.x);
        MWindowTest.assertEquals((int)300, (int)bounds.x);
    }

    public void TODOtestWindow_Y() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        MWindowTest.assertEquals((int)window.getY(), (int)bounds.y);
        MWindowTest.assertEquals((int)200, (int)bounds.y);
        window.setY(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        MWindowTest.assertEquals((int)300, (int)window.getY());
        MWindowTest.assertEquals((int)window.getY(), (int)bounds.y);
        MWindowTest.assertEquals((int)300, (int)bounds.y);
    }

    public void testWindow_Width() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((int)shell.getBounds().width, (int)window.getWidth());
        MWindowTest.assertEquals((int)200, (int)shell.getBounds().width);
        window.setWidth(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        MWindowTest.assertEquals((int)shell.getBounds().width, (int)window.getWidth());
        MWindowTest.assertEquals((int)300, (int)shell.getBounds().width);
    }

    public void testWindow_Height() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((int)shell.getBounds().height, (int)window.getHeight());
        MWindowTest.assertEquals((int)200, (int)shell.getBounds().height);
        window.setHeight(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        MWindowTest.assertEquals((int)shell.getBounds().height, (int)window.getHeight());
        MWindowTest.assertEquals((int)300, (int)shell.getBounds().height);
    }

    private MPart getContributedPart(MWindow window) {
        MPartSashContainer psc = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)psc.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MWindowTest.assertTrue((String)("part is incorrect type " + part), (boolean)(part instanceof MPart));
        return part;
    }

    private MWindow createWindowWithOneView() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel("Sample View");
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow createWindowWithOneViewAndMenu() {
        MWindow window = this.createWindowWithOneView();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setLabel("File");
        fileMenu.setElementId("file");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        return window;
    }
}

