/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTPartRendererTest
extends TestCase {
    private SWTPartRenderer renderer;
    private Shell shell;
    private MPart part;
    private IEclipseContext context;
    private Map<String, Object[]> stylingEngineExecutedMethods;

    public void setUp() throws Exception {
        this.renderer = new SWTPartRenderer(){

            public Object createWidget(MUIElement element, Object parent) {
                return null;
            }
        };
        this.shell = Display.getDefault().getActiveShell();
        this.stylingEngineExecutedMethods = new HashMap<String, Object[]>();
        this.context = EclipseContextFactory.create();
        this.context.set(IStylingEngine.SERVICE_NAME, Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IStylingEngine.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                SWTPartRendererTest.this.stylingEngineExecutedMethods.put(method.getName(), args);
                return null;
            }
        }));
        this.part = MBasicFactory.INSTANCE.createPart();
        this.part.setElementId("org.eclipse.elementId");
        this.part.setContext(this.context);
    }

    public void testSetCSSInfo() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        SWTPartRendererTest.assertNotNull((Object)setClassnameAndIdParams);
        SWTPartRendererTest.assertEquals((int)3, (int)setClassnameAndIdParams.length);
        SWTPartRendererTest.assertEquals((Object)button, (Object)setClassnameAndIdParams[0]);
        SWTPartRendererTest.assertEquals((String)"MPart", (String)setClassnameAndIdParams[1].toString());
        SWTPartRendererTest.assertEquals((String)"org-eclipse-elementId", (String)setClassnameAndIdParams[2].toString());
    }

    public void testSetCSSInfoWhenUIElementWithTags() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.part.getTags().add("tag1");
        this.part.getTags().add("tag2");
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        SWTPartRendererTest.assertNotNull((Object)setClassnameAndIdParams);
        SWTPartRendererTest.assertEquals((int)3, (int)setClassnameAndIdParams.length);
        SWTPartRendererTest.assertEquals((Object)button, (Object)setClassnameAndIdParams[0]);
        SWTPartRendererTest.assertEquals((String)"MPart tag1 tag2", (String)setClassnameAndIdParams[1].toString());
        SWTPartRendererTest.assertEquals((String)"org-eclipse-elementId", (String)setClassnameAndIdParams[2].toString());
    }

    public void testSetCSSInfoWhenNoCSSStylingEngineInContext() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.context.remove(IStylingEngine.SERVICE_NAME);
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        SWTPartRendererTest.assertNull((Object)setClassnameAndIdParams);
    }
}

