/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.emf.common.notify.Notifier;

public class Bug320857Test
extends TestCase {
    private IEclipseContext applicationContext;
    private IPresentationEngine engine;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected String getEngineURI() {
        return "bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationContext.dispose();
    }

    private void initialize(IEclipseContext applicationContext, MApplication application) {
        applicationContext.set(MApplication.class.getName(), (Object)application);
        application.setContext(applicationContext);
        UIEventPublisher ep = new UIEventPublisher(applicationContext);
        ((Notifier)application).eAdapters().add((Object)ep);
        applicationContext.set(UIEventPublisher.class, (Object)ep);
    }

    private IPresentationEngine getEngine() {
        if (this.engine == null) {
            IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class.getName());
            Object newEngine = contributionFactory.create(this.getEngineURI(), this.applicationContext);
            Bug320857Test.assertTrue((boolean)(newEngine instanceof IPresentationEngine));
            this.applicationContext.set(IPresentationEngine.class.getName(), newEngine);
            this.engine = (IPresentationEngine)newEngine;
        }
        return this.engine;
    }

    public void testBug320857() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        this.applicationContext.set(Bug320857.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(Bug320857.class, (IEclipseContext)context);
            }
        });
        IEclipseContext partContext = part.getContext();
        Bug320857 selectionServiceA = (Bug320857)partContext.get(Bug320857.class);
        selectionServiceA.setSelection(new Object());
        Bug320857 selectionServiceB = (Bug320857)partContext.get(Bug320857.class);
        Bug320857Test.assertEquals((Object)selectionServiceA, (Object)selectionServiceB);
        Bug320857Test.assertSame((Object)selectionServiceA, (Object)selectionServiceB);
    }

    public static class Bug320857 {
        static final String OUT_SELECTION = "output.selection";
        @Inject
        private IEclipseContext context;

        @Inject
        void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
            if (part != null) {
                IEclipseContext partContext = part.getContext();
                partContext.containsKey(OUT_SELECTION);
            }
        }

        public void setSelection(Object selection) {
            this.context.set(OUT_SELECTION, selection);
        }
    }
}

