/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class EModelServiceFindTest
extends TestCase {
    private IEclipseContext applicationContext;
    MApplication app = null;
    private EModelService modelService;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        this.modelService = new ModelServiceImpl(this.applicationContext);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationContext.dispose();
    }

    private MApplication createApplication() {
        MApplication app = ApplicationFactoryImpl.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setElementId("singleValidId");
        app.getChildren().add(window);
        MMenu mainMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(mainMenu);
        MMenu mainMenuItem = MenuFactoryImpl.eINSTANCE.createMenu();
        mainMenu.getChildren().add(mainMenuItem);
        MPartSashContainer psc = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        psc.setElementId("twoValidIds");
        psc.getTags().add("oneValidTag");
        window.getChildren().add(psc);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("twoValidTags");
        psc.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        part1.setElementId("twoValidIds");
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        part2.getTags().add("twoValidTags");
        part2.getTags().add("secondTag");
        stack.getChildren().add(part2);
        MPart part3 = BasicFactoryImpl.eINSTANCE.createPart();
        psc.getChildren().add(part3);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.setElementId("menuId");
        part1.getMenus().add(menu);
        MMenu menuItem1 = MenuFactoryImpl.eINSTANCE.createMenu();
        menuItem1.setElementId("menuItem1Id");
        menu.getChildren().add(menuItem1);
        MMenu menuItem2 = MenuFactoryImpl.eINSTANCE.createMenu();
        menuItem2.setElementId("menuItem2Id");
        menu.getChildren().add(menuItem2);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        toolBar.setElementId("toolBarId");
        part2.setToolbar(toolBar);
        MToolControl toolControl1 = MenuFactoryImpl.eINSTANCE.createToolControl();
        toolControl1.setElementId("toolControl1Id");
        toolBar.getChildren().add(toolControl1);
        MToolControl toolControl2 = MenuFactoryImpl.eINSTANCE.createToolControl();
        toolControl2.setElementId("toolControl2Id");
        toolBar.getChildren().add(toolControl2);
        return app;
    }

    public void testFindElementsIdOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List elements1 = modelService.findElements((MUIElement)application, "singleValidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements1.size(), (int)1);
        List elements2 = modelService.findElements((MUIElement)application, "twoValidIds", null, null);
        EModelServiceFindTest.assertEquals((int)elements2.size(), (int)2);
        List elements3 = modelService.findElements((MUIElement)application, "invalidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements3.size(), (int)0);
        List elements4 = modelService.findElements((MUIElement)application, "menuItem1Id", null, null, 125);
        EModelServiceFindTest.assertEquals((int)1, (int)elements4.size());
        List elements5 = modelService.findElements((MUIElement)application, "toolControl1Id", null, null, 125);
        EModelServiceFindTest.assertEquals((int)1, (int)elements5.size());
    }

    public void testFindElementsTypeOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List parts = modelService.findElements((MUIElement)application, null, MPart.class, null);
        EModelServiceFindTest.assertEquals((int)parts.size(), (int)3);
        List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class, null);
        EModelServiceFindTest.assertEquals((int)stacks.size(), (int)1);
        List dirtyableElements = modelService.findElements((MUIElement)application, null, MDirtyable.class, null);
        EModelServiceFindTest.assertEquals((int)dirtyableElements.size(), (int)3);
        List menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 125);
        EModelServiceFindTest.assertEquals((int)5, (int)menuElements.size());
        List toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 125);
        EModelServiceFindTest.assertEquals((int)2, (int)toolBarElements.size());
        List uiElements = modelService.findElements((MUIElement)application, null, null, null, 125);
        EModelServiceFindTest.assertEquals((int)15, (int)uiElements.size());
        List strings = modelService.findElements((MUIElement)application, null, String.class, null);
        EModelServiceFindTest.assertEquals((int)strings.size(), (int)0);
    }

    public void testFindElementsTagsOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List oneTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)oneTags.size(), (int)1);
        tags.clear();
        tags.add("twoValidTags");
        List twoTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)twoTags.size(), (int)2);
        tags.clear();
        tags.add("invalidTag");
        List invalidTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)invalidTags.size(), (int)0);
        tags.clear();
        tags.add("twoValidTags");
        tags.add("secondTag");
        List combinedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)combinedTags.size(), (int)1);
        tags.clear();
        tags.add("oneValidTag");
        tags.add("secondTag");
        List unmatchedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)unmatchedTags.size(), (int)0);
    }

    public void testFindElementsCombinations() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List idAndType = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)idAndType.size(), (int)1);
        List typeAndTag = modelService.findElements((MUIElement)application, null, MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)typeAndTag.size(), (int)1);
        List idAndTag = modelService.findElements((MUIElement)application, "twoValidIds", null, tags);
        EModelServiceFindTest.assertEquals((int)idAndTag.size(), (int)1);
        List idAndTypeAndTags = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)idAndTypeAndTags.size(), (int)1);
        List badIdAndTypeAndTags = modelService.findElements((MUIElement)application, "invalidId", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)badIdAndTypeAndTags.size(), (int)0);
    }

    public void testFindElements_NullCheck() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        try {
            modelService.find("a", null);
            EModelServiceFindTest.fail((String)"An exception should have prevented a null parameter to find(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            modelService.findElements(null, null, null, null);
            EModelServiceFindTest.fail((String)"An exception should have prevented a null parameter to findElements(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            modelService.findElements(null, null, null, null, 29);
            EModelServiceFindTest.fail((String)"An exception should have prevented a null parameter to findElements(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testFlags() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 4);
        EModelServiceFindTest.assertEquals((int)0, (int)toolBarElements.size());
        toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 68);
        EModelServiceFindTest.assertEquals((int)2, (int)toolBarElements.size());
        List menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 4);
        EModelServiceFindTest.assertEquals((int)0, (int)menuElements.size());
        menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 68);
        EModelServiceFindTest.assertEquals((int)3, (int)menuElements.size());
        menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 36);
        EModelServiceFindTest.assertEquals((int)2, (int)menuElements.size());
    }

    private MHandler findHandler(EModelService ms, MApplicationElement searchRoot, final String id) {
        if (searchRoot == null || id == null) {
            return null;
        }
        List handlers = ms.findElements(searchRoot, MHandler.class, 29, new Selector(){

            public boolean select(MApplicationElement element) {
                return element instanceof MHandler && id.equals(element.getElementId());
            }
        });
        if (handlers.size() > 0) {
            return (MHandler)handlers.get(0);
        }
        return null;
    }

    public void testFindHandler() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        MHandler handler1 = CommandsFactoryImpl.eINSTANCE.createHandler();
        handler1.setElementId("handler1");
        application.getHandlers().add(handler1);
        MHandler handler2 = MCommandsFactory.INSTANCE.createHandler();
        handler2.setElementId("handler2");
        application.getHandlers().add(handler2);
        MHandler foundHandler = null;
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "handler1");
        EModelServiceFindTest.assertNotNull((Object)foundHandler);
        EModelServiceFindTest.assertSame((Object)handler1, (Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "invalidId");
        EModelServiceFindTest.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, null, "handler1");
        EModelServiceFindTest.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "");
        EModelServiceFindTest.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, null);
        EModelServiceFindTest.assertNull((Object)foundHandler);
    }

    public void testFindMKeyBindings() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        MBindingTable bindingTable = MCommandsFactory.INSTANCE.createBindingTable();
        MKeyBinding keyBinding = MCommandsFactory.INSTANCE.createKeyBinding();
        bindingTable.getBindings().add(keyBinding);
        application.getBindingTables().add(bindingTable);
        List elements = modelService.findElements((MApplicationElement)application, MKeyBinding.class, 29, new Selector(){

            public boolean select(MApplicationElement element) {
                return element instanceof MKeyBinding;
            }
        });
        EModelServiceFindTest.assertEquals((int)1, (int)elements.size());
        EModelServiceFindTest.assertEquals((Object)keyBinding, elements.get(0));
    }

    public void testBug314685() {
        MApplication application = this.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = (MWindow)this.modelService.createModelElement(MWindow.class);
        application.getChildren().add(window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.modelService.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.modelService.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        MPerspective perspectiveB = (MPerspective)this.modelService.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPart part = (MPart)this.modelService.createModelElement(MPart.class);
        partStack.getChildren().add(part);
        MPlaceholder placeholderA = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partStack);
        perspectiveA.getChildren().add(placeholderA);
        MPlaceholder placeholderB = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List elements = modelService.findElements((MUIElement)window, null, MPart.class, null);
        EModelServiceFindTest.assertNotNull((Object)elements);
        EModelServiceFindTest.assertEquals((int)1, (int)elements.size());
        EModelServiceFindTest.assertEquals((Object)part, elements.get(0));
    }
}

