/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.Arrays;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.emf.common.util.EList;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class UIEventTypesTest
extends HeadlessApplicationElementTest {
    private Event event;
    private int eventCount;

    @Override
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        MApplication application = MApplicationFactory.INSTANCE.createApplication();
        return application;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IEventBroker appEB = (IEventBroker)this.applicationContext.get(IEventBroker.class);
        this.eventCount = 0;
        appEB.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", new EventHandler(){

            public void handleEvent(Event event) {
                UIEventTypesTest uIEventTypesTest = UIEventTypesTest.this;
                uIEventTypesTest.eventCount = uIEventTypesTest.eventCount + 1;
                UIEventTypesTest.this.event = event;
            }
        });
        appEB.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*", new EventHandler(){

            public void handleEvent(Event event) {
                UIEventTypesTest uIEventTypesTest = UIEventTypesTest.this;
                uIEventTypesTest.eventCount = uIEventTypesTest.eventCount + 1;
                UIEventTypesTest.this.event = event;
            }
        });
    }

    public void testAdd() {
        this.applicationElement.getTags().add("0");
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"ADD", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals((Object)0, (Object)this.event.getProperty("Position"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals((Object)"0", (Object)this.event.getProperty("NewValue"));
    }

    public void testAddMany() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"ADD_MANY", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals((Object)0, (Object)this.event.getProperty("Position"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals(Arrays.asList("0", "1", "2"), (Object)this.event.getProperty("NewValue"));
    }

    public void testRemove() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().remove("1");
        UIEventTypesTest.assertEquals((int)2, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)1, (Object)this.event.getProperty("Position"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"REMOVE", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals((Object)"1", (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("NewValue"));
    }

    public void testRemoveMany() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().removeAll(Arrays.asList("2", "0"));
        UIEventTypesTest.assertEquals((int)2, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"REMOVE_MANY", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals(Arrays.asList("0", "2"), (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertTrue((boolean)(this.event.getProperty("Position") instanceof int[]));
        int[] removedPositions = (int[])this.event.getProperty("Position");
        UIEventTypesTest.assertEquals((int)0, (int)removedPositions[0]);
        UIEventTypesTest.assertEquals((int)2, (int)removedPositions[1]);
    }

    public void testRetain() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().retainAll(Arrays.asList("0"));
        UIEventTypesTest.assertEquals((int)3, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"REMOVE", (Object)this.event.getProperty("EventType"));
    }

    public void testClear() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().clear();
        UIEventTypesTest.assertEquals((int)2, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"REMOVE_MANY", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals(Arrays.asList("0", "1", "2"), (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("NewValue"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("Position"));
    }

    public void testMove() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        this.event = null;
        ((EList)this.applicationElement.getTags()).move(0, 2);
        UIEventTypesTest.assertEquals((int)2, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"MOVE", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals((Object)"2", (Object)this.event.getProperty("NewValue"));
        UIEventTypesTest.assertEquals((String)"former position", (Object)2, (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals((String)"new position", (Object)0, (Object)this.event.getProperty("Position"));
    }

    public void testSet() {
        this.applicationElement.setElementId("aaa");
        UIEventTypesTest.assertEquals((int)1, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"elementId", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"SET", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals((Object)"aaa", (Object)this.event.getProperty("NewValue"));
        this.applicationElement.setElementId(null);
        UIEventTypesTest.assertEquals((int)2, (int)this.eventCount);
        UIEventTypesTest.assertNotNull((Object)this.event);
        UIEventTypesTest.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        UIEventTypesTest.assertEquals((Object)"elementId", (Object)this.event.getProperty("AttName"));
        UIEventTypesTest.assertEquals((Object)"SET", (Object)this.event.getProperty("EventType"));
        UIEventTypesTest.assertEquals((Object)"aaa", (Object)this.event.getProperty("OldValue"));
        UIEventTypesTest.assertEquals(null, (Object)this.event.getProperty("NewValue"));
    }
}

