/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ExtensionsSortTests
extends TestCase {
    Bundle root;
    Bundle intermediate;
    Bundle leaf;

    protected void setUp() throws Exception {
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        this.root = context.installBundle(this.toFileURL("platform:/plugin/" + context.getBundle().getSymbolicName() + "/data/org.eclipse.extensionsSortTests/tests.extensions.root/"));
        this.intermediate = context.installBundle(this.toFileURL("platform:/plugin/" + context.getBundle().getSymbolicName() + "/data/org.eclipse.extensionsSortTests/tests.extensions.intermediate/"));
        this.leaf = context.installBundle(this.toFileURL("platform:/plugin/" + context.getBundle().getSymbolicName() + "/data/org.eclipse.extensionsSortTests/tests.extensions.leaf/"));
        this.root.start(1);
        this.intermediate.start(1);
        this.leaf.start(1);
    }

    public void testSortOrder() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.workbench.model");
        IExtension[] extensions = (IExtension[])new ExtensionsSort().sort((Object[])extPoint.getExtensions());
        int rootIndex = this.indexOf(extensions, "test.extensions.root.model");
        int intermediateIndex = this.indexOf(extensions, "test.extensions.intermediate.model");
        int leafIndex = this.indexOf(extensions, "test.extensions.leaf.model");
        ExtensionsSortTests.assertTrue((rootIndex < intermediateIndex ? 1 : 0) != 0);
        ExtensionsSortTests.assertTrue((intermediateIndex < leafIndex ? 1 : 0) != 0);
    }

    private String toFileURL(String url) throws MalformedURLException, IOException {
        return FileLocator.toFileURL((URL)new URL(url)).toString();
    }

    private int indexOf(IExtension[] extensions, String id) {
        int i = 0;
        while (i < extensions.length) {
            if (id.equals(extensions[i].getUniqueIdentifier())) {
                return i;
            }
            ++i;
        }
        ExtensionsSortTests.fail((String)("Could not find extensions with id " + id));
        return Integer.MIN_VALUE;
    }

    protected void tearDown() throws Exception {
        if (this.root != null) {
            this.root.uninstall();
        }
        if (this.intermediate != null) {
            this.intermediate.uninstall();
        }
        if (this.leaf != null) {
            this.leaf.uninstall();
        }
    }
}

