/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;

public class MToolItemTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    private void testMToolItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem.setLabel(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = toolItem.getWidget();
        MToolItemTest.assertNotNull((Object)widget);
        MToolItemTest.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        MToolItemTest.assertEquals((String)beforeExpected, (String)toolItemWidget.getText());
        toolItem.setLabel(after);
        MToolItemTest.assertEquals((String)afterExpected, (String)toolItemWidget.getText());
    }

    public void testMToolItem_Text_NullNull() {
        this.testMToolItem_Text(null, "", null, "");
    }

    public void testMToolItem_Text_NullEmpty() {
        this.testMToolItem_Text(null, "", "", "");
    }

    public void testMToolItem_Text_NullString() {
        this.testMToolItem_Text(null, "", "label", "label");
    }

    public void testMToolItem_Text_EmptyNull() {
        this.testMToolItem_Text("", "", null, "");
    }

    public void testMToolItem_Text_EmptyEmpty() {
        this.testMToolItem_Text("", "", "", "");
    }

    public void testMToolItem_Text_EmptyString() {
        this.testMToolItem_Text("", "", "label", "label");
    }

    public void testMToolItem_Text_StringNull() {
        this.testMToolItem_Text("label", "label", null, "");
    }

    public void testMToolItem_Text_StringEmpty() {
        this.testMToolItem_Text("label", "label", "", "");
    }

    public void testMToolItem_Text_StringStringUnchanged() {
        this.testMToolItem_Text("label", "label", "label", "label");
    }

    public void testMToolItem_Text_StringStringChanged() {
        this.testMToolItem_Text("label", "label", "label2", "label2");
    }

    private void testMToolItem_Tooltip(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem.setTooltip(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = toolItem.getWidget();
        MToolItemTest.assertNotNull((Object)widget);
        MToolItemTest.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        MToolItemTest.assertEquals((String)beforeExpected, (String)toolItemWidget.getToolTipText());
        toolItem.setTooltip(after);
        MToolItemTest.assertEquals((String)afterExpected, (String)toolItemWidget.getToolTipText());
    }

    public void testMToolItem_Tooltip_NullNull() {
        this.testMToolItem_Tooltip(null, null, null, null);
    }

    public void testMToolItem_Tooltip_NullEmpty() {
        this.testMToolItem_Tooltip(null, null, "", "");
    }

    public void testMToolItem_Tooltip_NullString() {
        this.testMToolItem_Tooltip(null, null, "toolTip", "toolTip");
    }

    public void testMToolItem_Tooltip_EmptyNull() {
        this.testMToolItem_Tooltip("", "", null, null);
    }

    public void testMToolItem_Tooltip_EmptyEmpty() {
        this.testMToolItem_Tooltip("", "", "", "");
    }

    public void testMToolItem_Tooltip_EmptyString() {
        this.testMToolItem_Tooltip("", "", "toolTip", "toolTip");
    }

    public void testMToolItem_Tooltip_StringNull() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", null, null);
    }

    public void testMToolItem_Tooltip_StringEmpty() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "", "");
    }

    public void testMToolItem_Tooltip_StringStringUnchanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip", "toolTip");
    }

    public void testMToolItem_Tooltip_StringStringChanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip2", "toolTip2");
    }

    public void testMToolItem_RadioItems() {
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        MDirectToolItem toolItem1 = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        MDirectToolItem toolItem2 = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem1.setType(ItemType.RADIO);
        toolItem2.setType(ItemType.RADIO);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem1);
        toolBar.getChildren().add(toolItem2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget1 = toolItem1.getWidget();
        MToolItemTest.assertNotNull((Object)widget1);
        MToolItemTest.assertTrue((boolean)(widget1 instanceof ToolItem));
        Object widget2 = toolItem2.getWidget();
        MToolItemTest.assertNotNull((Object)widget2);
        MToolItemTest.assertTrue((boolean)(widget2 instanceof ToolItem));
        ToolItem toolItemWidget1 = (ToolItem)widget1;
        ToolItem toolItemWidget2 = (ToolItem)widget2;
        toolItemWidget1.setSelection(false);
        toolItemWidget2.setSelection(true);
        toolItemWidget1.notifyListeners(13, new Event());
        toolItemWidget2.notifyListeners(13, new Event());
        MToolItemTest.assertFalse((boolean)toolItem1.isSelected());
        MToolItemTest.assertTrue((boolean)toolItem2.isSelected());
        toolItemWidget2.setSelection(false);
        toolItemWidget1.setSelection(true);
        toolItemWidget2.notifyListeners(13, new Event());
        toolItemWidget1.notifyListeners(13, new Event());
        MToolItemTest.assertTrue((boolean)toolItem1.isSelected());
        MToolItemTest.assertFalse((boolean)toolItem2.isSelected());
        toolItem1.setSelected(false);
        MToolItemTest.assertFalse((boolean)toolItemWidget1.getSelection());
        toolItem2.setSelected(true);
        MToolItemTest.assertTrue((boolean)toolItemWidget2.getSelection());
    }
}

