/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.swt.widgets.Display;

public class SashRendererTest
extends TestCase {
    private IEclipseContext appContext;
    private E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void testBug310027() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MPartSashContainer container = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        window.setWidth(600);
        window.setHeight(400);
        partStackA.setContainerData("50");
        partStackB.setContainerData("50");
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getChildren().add(container);
        window.setSelectedElement((MUIElement)container);
        container.getChildren().add(partStackA);
        container.getChildren().add(partStackB);
        container.setSelectedElement((MUIElement)partStackA);
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        partStackA.getChildren().add(partB);
        partStackA.setSelectedElement((MUIElement)partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SashRendererTest.assertEquals((String)"50", (String)partStackA.getContainerData());
        SashRendererTest.assertEquals((String)"50", (String)partStackB.getContainerData());
        partStackB.setToBeRendered(false);
        while (Display.getDefault().readAndDispatch()) {
        }
        SashRendererTest.assertEquals((String)"50", (String)partStackA.getContainerData());
    }
}

