/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;

public class StackRendererTest
extends TestCase {
    private IEclipseContext context;
    private E4Workbench wb;
    private MPart part;
    private CTabItemStylingMethodsListener executedMethodsListener;
    private MPartStack partStack;

    protected void setUp() throws Exception {
        this.context = E4Application.createDefaultContext();
        this.context.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        this.partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        this.part = BasicFactoryImpl.eINSTANCE.createPart();
        this.part.setLabel("some title");
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getChildren().add(this.partStack);
        this.partStack.getChildren().add(this.part);
        application.setContext(this.context);
        this.context.set(MApplication.class.getName(), (Object)application);
        this.executedMethodsListener = new CTabItemStylingMethodsListener(this.part);
        this.wb = new E4Workbench((MApplicationElement)application, this.context);
        this.wb.getContext().set(IStylingEngine.class, (Object)((IStylingEngine)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IStylingEngine.class}, (InvocationHandler)this.executedMethodsListener)));
        this.wb.createAndRunUI((MApplicationElement)window);
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.context.dispose();
    }

    public void testTabStateHandlerWhenOneOfSupportedTagChangeEvents() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", this.part);
        params.put("NewValue", "busy");
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*".replace("*", "SET"), params);
        StackRendererTest.assertEquals((int)1, (int)this.executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    public void testTabStateHandlerWhenSelectionChangedEvent() throws Exception {
        MPlaceholder placeHolder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeHolder.setRef((MUIElement)this.part);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", this.partStack);
        params.put("NewValue", placeHolder);
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*".replace("*", "SET"), params);
        StackRendererTest.assertEquals((int)1, (int)this.executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    private static class CTabItemStylingMethodsListener
    implements InvocationHandler {
        private MPart part;
        private List<String> methods;

        public CTabItemStylingMethodsListener(MPart part) {
            this.part = part;
            this.methods = new ArrayList<String>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.isTabItemForPart(args[0])) {
                this.methods.add(String.format("%s(%s)", method.getName(), Arrays.toString(args)));
            }
            return null;
        }

        private boolean isTabItemForPart(Object obj) {
            return obj instanceof CTabItem && this.part.getLabel().equals(((CTabItem)obj).getText());
        }

        public int getMethodExecutionCount(String methodPattern) {
            int result = 0;
            for (String method : this.methods) {
                if (!method.matches(methodPattern)) continue;
                ++result;
            }
            return result;
        }
    }
}

