/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.swt.resources.ResourceByDefinitionKey;
import org.eclipse.e4.ui.css.swt.resources.SWTResourcesRegistry;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.renderers.swt.WBWRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.osgi.service.event.Event;

public class ThemeDefinitionChangedHandlerTest
extends TestCase {
    public void testHandleEventWhenThemeChanged() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(MBasicFactory.INSTANCE.createWindow());
        application.getChildren().add(MBasicFactory.INSTANCE.createWindow());
        HashMap<String, MApplication> params = new HashMap<String, MApplication>();
        params.put("org.eclipse.e4.data", application);
        Event event = new Event("topic", params);
        Resource resource1 = (Resource)Mockito.mock(Resource.class);
        ((Resource)Mockito.doReturn((Object)false).when((Object)resource1)).isDisposed();
        Resource resource2 = (Resource)Mockito.mock(Resource.class);
        ((Resource)Mockito.doReturn((Object)true).when((Object)resource2)).isDisposed();
        Object resource3 = new Object();
        ArrayList<Object> removedResources = new ArrayList<Object>();
        removedResources.add(resource1);
        removedResources.add(resource2);
        removedResources.add(resource3);
        SWTResourcesRegistry registry = (SWTResourcesRegistry)Mockito.mock(SWTResourcesRegistry.class);
        ((SWTResourcesRegistry)Mockito.doReturn(removedResources).when((Object)registry)).removeResourcesByKeyTypeAndType(ResourceByDefinitionKey.class, new Class[]{Font.class, Color.class});
        CSSEngine engine = (CSSEngine)Mockito.mock(CSSEngine.class);
        ((CSSEngine)Mockito.doReturn((Object)registry).when((Object)engine)).getResourcesRegistry();
        ThemeDefinitionChangedHandlerTestable handler = (ThemeDefinitionChangedHandlerTestable)((Object)Mockito.spy((Object)((Object)new ThemeDefinitionChangedHandlerTestable())));
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.doReturn((Object)engine).when((Object)handler))).getEngine((MWindow)Matchers.any(MWindow.class));
        handler.handleEvent(event);
        ((CSSEngine)Mockito.verify((Object)engine, (VerificationMode)Mockito.times((int)1))).reapply();
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).removeResources((IResourcesRegistry)registry);
        ThemeDefinitionChangedHandlerTest.assertEquals((int)1, (int)handler.getUnusedResources().size());
        ThemeDefinitionChangedHandlerTest.assertTrue((boolean)handler.getUnusedResources().contains(resource1));
        ((Resource)Mockito.verify((Object)resource1, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Resource)Mockito.verify((Object)resource1, (VerificationMode)Mockito.never())).dispose();
        ((Resource)Mockito.verify((Object)resource2, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Resource)Mockito.verify((Object)resource2, (VerificationMode)Mockito.never())).dispose();
    }

    public void testHandleEventWhenElementIsNotMApplication() throws Exception {
        HashMap<String, MWindow> params = new HashMap<String, MWindow>();
        params.put("org.eclipse.e4.data", MBasicFactory.INSTANCE.createWindow());
        Event event = new Event("topic", params);
        CSSEngine engine = (CSSEngine)Mockito.mock(CSSEngine.class);
        ThemeDefinitionChangedHandlerTestable handler = (ThemeDefinitionChangedHandlerTestable)((Object)Mockito.spy((Object)((Object)new ThemeDefinitionChangedHandlerTestable())));
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.doReturn((Object)engine).when((Object)handler))).getEngine((MWindow)Matchers.any(MWindow.class));
        handler.handleEvent(event);
        ((CSSEngine)Mockito.verify((Object)engine, (VerificationMode)Mockito.never())).reapply();
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.never()))).removeResources((IResourcesRegistry)Matchers.any(IResourcesRegistry.class));
        ThemeDefinitionChangedHandlerTest.assertEquals((int)0, (int)handler.getUnusedResources().size());
    }

    public void testHandleEventWhenCSSEngineNotFoundForWidget() throws Exception {
        MWindow window1 = MBasicFactory.INSTANCE.createWindow();
        MWindow window2 = MBasicFactory.INSTANCE.createWindow();
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window1);
        application.getChildren().add(window2);
        HashMap<String, MApplication> params = new HashMap<String, MApplication>();
        params.put("org.eclipse.e4.data", application);
        Event event = new Event("topic", params);
        SWTResourcesRegistry registry = (SWTResourcesRegistry)Mockito.mock(SWTResourcesRegistry.class);
        CSSEngine engine = (CSSEngine)Mockito.mock(CSSEngine.class);
        ((CSSEngine)Mockito.doReturn((Object)registry).when((Object)engine)).getResourcesRegistry();
        ThemeDefinitionChangedHandlerTestable handler = (ThemeDefinitionChangedHandlerTestable)((Object)Mockito.spy((Object)((Object)new ThemeDefinitionChangedHandlerTestable())));
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.doReturn(null).when((Object)handler))).getEngine(window1);
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.doReturn((Object)engine).when((Object)handler))).getEngine(window2);
        handler.handleEvent(event);
        ((CSSEngine)Mockito.verify((Object)engine, (VerificationMode)Mockito.times((int)1))).reapply();
        ((ThemeDefinitionChangedHandlerTestable)((Object)Mockito.verify((Object)((Object)handler), (VerificationMode)Mockito.times((int)1)))).removeResources((IResourcesRegistry)registry);
        ThemeDefinitionChangedHandlerTest.assertEquals((int)0, (int)handler.getUnusedResources().size());
    }

    public void testDisposeHandler() throws Exception {
        ThemeDefinitionChangedHandlerTestable handler = (ThemeDefinitionChangedHandlerTestable)((Object)Mockito.spy((Object)((Object)new ThemeDefinitionChangedHandlerTestable())));
        Resource resource1 = (Resource)Mockito.mock(Resource.class);
        ((Resource)Mockito.doReturn((Object)false).when((Object)resource1)).isDisposed();
        handler.getUnusedResources().add(resource1);
        Resource resource2 = (Resource)Mockito.mock(Resource.class);
        ((Resource)Mockito.doReturn((Object)true).when((Object)resource2)).isDisposed();
        handler.getUnusedResources().add(resource2);
        handler.dispose();
        ThemeDefinitionChangedHandlerTest.assertTrue((boolean)handler.getUnusedResources().isEmpty());
        ((Resource)Mockito.verify((Object)resource1, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Resource)Mockito.verify((Object)resource1, (VerificationMode)Mockito.times((int)1))).dispose();
        ((Resource)Mockito.verify((Object)resource2, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Resource)Mockito.verify((Object)resource2, (VerificationMode)Mockito.never())).dispose();
    }

    protected static class ThemeDefinitionChangedHandlerTestable
    extends WBWRenderer.ThemeDefinitionChangedHandler {
        List<Object> processedRemovedResources;

        protected ThemeDefinitionChangedHandlerTestable() {
        }

        public CSSEngine getEngine(MWindow window) {
            return super.getEngine(window);
        }

        public List<Object> removeResources(IResourcesRegistry registry) {
            return super.removeResources(registry);
        }

        public Set<Resource> getUnusedResources() {
            return this.unusedResources;
        }
    }
}

