/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextMath;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;

public class StructuredTextMathTest
extends StructuredTextTestBase {
    private StructuredTextEnvironment envLTR = new StructuredTextEnvironment("ar", false, 0);
    private StructuredTextEnvironment envRTL = new StructuredTextEnvironment("ar", false, 1);
    private IStructuredTextExpert expertLTR = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)new StructuredTextMath(), (StructuredTextEnvironment)this.envLTR);
    private IStructuredTextExpert expertRTL = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)new StructuredTextMath(), (StructuredTextEnvironment)this.envRTL);

    private void verifyOneLine(String msg, String data, String resLTR, String resRTL) {
        String lean = StructuredTextMathTest.toUT16(data);
        String fullLTR = this.expertLTR.leanToFullText(lean);
        StructuredTextMathTest.assertEquals((String)(String.valueOf(msg) + " LTR - "), (String)resLTR, (String)StructuredTextMathTest.toPseudo(fullLTR));
        String fullRTL = this.expertRTL.leanToFullText(lean);
        StructuredTextMathTest.assertEquals((String)(String.valueOf(msg) + " RTL - "), (String)resRTL, (String)StructuredTextMathTest.toPseudo(fullRTL));
    }

    public void testRTLarithmetic() {
        this.verifyOneLine("Math #0", "", "", "");
        this.verifyOneLine("Math #1", "1+ABC", "1+ABC", ">@1+ABC@^");
        this.verifyOneLine("Math #2", "2+ABC-DEF", "2+ABC@-DEF", ">@2+ABC@-DEF@^");
        this.verifyOneLine("Math #3", "A+3*BC/DEF", "A@+3*BC@/DEF", ">@A@+3*BC@/DEF@^");
        this.verifyOneLine("Math #4", "4+ABC/DEF", "4+ABC@/DEF", ">@4+ABC@/DEF@^");
        this.verifyOneLine("Math #5", "5#BC", "<&5#BC&^", "5#BC");
        this.verifyOneLine("Math #6", "6#BC-DE", "<&6#BC-DE&^", "6#BC-DE");
        this.verifyOneLine("Math #7", "7#BC+DE", "<&7#BC+DE&^", "7#BC+DE");
        this.verifyOneLine("Math #8", "8#BC*DE", "<&8#BC*DE&^", "8#BC*DE");
        this.verifyOneLine("Math #9", "9#BC/DE", "<&9#BC/DE&^", "9#BC/DE");
        this.verifyOneLine("Math #10", "10ab+cd-ef", "10ab+cd-ef", ">@10ab+cd-ef@^");
    }
}

