/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.StructuredTextTypeHandlerFactory;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;

public class StructuredTextMethodsTest
extends StructuredTextTestBase {
    private static final int LTR = 0;
    private static final int RTL = 1;
    private static final StructuredTextEnvironment envLTR = new StructuredTextEnvironment(null, false, 0);
    private static final StructuredTextEnvironment envRTL = new StructuredTextEnvironment(null, false, 1);
    private static final StructuredTextEnvironment envRTLMIR = new StructuredTextEnvironment(null, true, 1);
    private static final StructuredTextEnvironment envIGN = new StructuredTextEnvironment(null, false, 8);
    private static final StructuredTextEnvironment envCLR = new StructuredTextEnvironment(null, false, 2);
    private static final StructuredTextEnvironment envCRL = new StructuredTextEnvironment(null, false, 3);
    private static final StructuredTextEnvironment envERR = new StructuredTextEnvironment(null, false, 9999);
    private static final TestHandlerMyComma testMyCommaLL = new TestHandlerMyComma(0, 0);
    private static final TestHandlerMyComma testMyCommaRR = new TestHandlerMyComma(1, 1);
    private static final TestHandlerMyComma testMyCommaRL = new TestHandlerMyComma(1, 0);

    private void doTestTools() {
        String data = "56789ABCDEFGHIJKLMNOPQRSTUVWXYZ~#@&><^|`";
        String text = StructuredTextMethodsTest.toUT16(data);
        String dat2 = StructuredTextMethodsTest.toPseudo(text);
        StructuredTextMethodsTest.assertEquals((String)data, (String)dat2);
        text = StructuredTextMethodsTest.toPseudo(data);
        StructuredTextMethodsTest.assertEquals((String)"56789abcdefghijklmnopqrstuvwxyz~#@&><^|`", (String)text);
        text = StructuredTextMethodsTest.array_display(null);
        StructuredTextMethodsTest.assertEquals((String)"null", (String)text);
    }

    private void doTestState() {
        IStructuredTextExpert expert = StructuredTextExpertFactory.getStatefulExpert((String)"java");
        String data = "A=B+C;/* D=E+F;";
        String lean = StructuredTextMethodsTest.toUT16(data);
        String full = expert.leanToFullText(lean);
        String model = "A@=B@+C@;/* D=E+F;";
        StructuredTextMethodsTest.assertEquals((String)"full1", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "A=B+C; D=E+F;";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = data;
        StructuredTextMethodsTest.assertEquals((String)"full2", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "SOME MORE COMMENTS";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = data;
        StructuredTextMethodsTest.assertEquals((String)"full3", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "A=B+C;*/ D=E+F;";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = "A=B+C;@*/ D@=E@+F;";
        StructuredTextMethodsTest.assertEquals((String)"full4", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
    }

    private void doTestOrientation() {
        int orient = StructuredTextEnvironment.DEFAULT.getOrientation();
        StructuredTextMethodsTest.assertEquals((String)"orient #1", (int)0, (int)orient);
        orient = envIGN.getOrientation();
        StructuredTextMethodsTest.assertEquals((String)"orient #2", (int)8, (int)orient);
        orient = envCRL.getOrientation();
        StructuredTextMethodsTest.assertEquals((String)"orient #3", (int)3, (int)orient);
        orient = envERR.getOrientation();
        StructuredTextMethodsTest.assertEquals((String)"orient #4", (int)4, (int)orient);
    }

    private void doTestOrient(StructuredTextTypeHandler handler, String label, String data, String resLTR, String resRTL, String resCon) {
        IStructuredTextExpert expertLTR = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler, (StructuredTextEnvironment)envLTR);
        IStructuredTextExpert expertRTL = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler, (StructuredTextEnvironment)envRTL);
        IStructuredTextExpert expertCRL = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)handler, (StructuredTextEnvironment)envCRL);
        String lean = StructuredTextMethodsTest.toUT16(data);
        String full = expertLTR.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)(String.valueOf(label) + "LTR full"), (String)resLTR, (String)StructuredTextMethodsTest.toPseudo(full));
        full = expertRTL.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)"label + RTL full", (String)resRTL, (String)StructuredTextMethodsTest.toPseudo(full));
        full = expertCRL.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)(String.valueOf(label) + "CON full"), (String)resCon, (String)StructuredTextMethodsTest.toPseudo(full));
    }

    private void doTestSkipProcessing() {
        this.doTestOrient(testMyCommaLL, "Skip #1 ", "BCD,EF", "BCD@,EF", ">@BCD@,EF@^", "@BCD@,EF");
        this.doTestOrient(testMyCommaLL, "Skip #2 ", "#CD,EF", "#CD,EF", ">@#CD,EF@^", "@#CD,EF");
    }

    private void doTestLeanOffsets() {
        IStructuredTextExpert expert = StructuredTextExpertFactory.getStatefulExpert((String)"java");
        String data = "A=B+C;/* D=E+F;";
        String lean = StructuredTextMethodsTest.toUT16(data);
        int[] offsets = expert.leanBidiCharOffsets(lean);
        int[] model = new int[]{1, 3, 5};
        String label = "leanBidiCharOffsets() #1 ";
        StructuredTextMethodsTest.assertEquals((String)label, (String)StructuredTextMethodsTest.array_display(model), (String)StructuredTextMethodsTest.array_display(offsets));
        data = "A=B+C;*/ D=E+F;";
        lean = StructuredTextMethodsTest.toUT16(data);
        offsets = expert.leanBidiCharOffsets(lean);
        model = new int[]{6, 10, 12};
        label = "leanBidiCharOffsets() #2 ";
        StructuredTextMethodsTest.assertEquals((String)label, (String)StructuredTextMethodsTest.array_display(model), (String)StructuredTextMethodsTest.array_display(offsets));
    }

    private void doTestFullOffsets(String label, String data, int[] resLTR, int[] resRTL, int[] resCon) {
        IStructuredTextExpert expertLTR = StructuredTextExpertFactory.getExpert((String)"comma", (StructuredTextEnvironment)envLTR);
        IStructuredTextExpert expertRTL = StructuredTextExpertFactory.getExpert((String)"comma", (StructuredTextEnvironment)envRTL);
        IStructuredTextExpert expertCLR = StructuredTextExpertFactory.getExpert((String)"comma", (StructuredTextEnvironment)envCLR);
        String lean = StructuredTextMethodsTest.toUT16(data);
        String full = expertLTR.leanToFullText(lean);
        int[] offsets = expertLTR.fullBidiCharOffsets(full);
        String msg = String.valueOf(label) + "LTR ";
        StructuredTextMethodsTest.assertEquals((String)msg, (String)StructuredTextMethodsTest.array_display(resLTR), (String)StructuredTextMethodsTest.array_display(offsets));
        full = expertRTL.leanToFullText(lean);
        offsets = expertRTL.fullBidiCharOffsets(full);
        msg = String.valueOf(label) + "RTL ";
        StructuredTextMethodsTest.assertEquals((String)msg, (String)StructuredTextMethodsTest.array_display(resRTL), (String)StructuredTextMethodsTest.array_display(offsets));
        full = expertCLR.leanToFullText(lean);
        offsets = expertCLR.fullBidiCharOffsets(full);
        msg = String.valueOf(label) + "CON ";
        StructuredTextMethodsTest.assertEquals((String)msg, (String)StructuredTextMethodsTest.array_display(resCon), (String)StructuredTextMethodsTest.array_display(offsets));
    }

    private void doTestMirrored() {
        boolean mirrored = StructuredTextEnvironment.DEFAULT.getMirrored();
        StructuredTextMethodsTest.assertFalse((String)"mirrored #1", (boolean)mirrored);
        StructuredTextEnvironment env = new StructuredTextEnvironment(null, true, 0);
        mirrored = env.getMirrored();
        StructuredTextMethodsTest.assertTrue((String)"mirrored #2", (boolean)mirrored);
    }

    private void doTestDirection() {
        IStructuredTextExpert expertRL = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)testMyCommaRL, (StructuredTextEnvironment)envLTR);
        int dirA = expertRL.getTextDirection(StructuredTextMethodsTest.toUT16("###"));
        int dirH = expertRL.getTextDirection(StructuredTextMethodsTest.toUT16("ABC"));
        StructuredTextMethodsTest.assertTrue((String)"TestDirection #1", (dirA == 1 && dirH == 0 ? 1 : 0) != 0);
        IStructuredTextExpert expertRR = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)testMyCommaRR, (StructuredTextEnvironment)envLTR);
        dirA = expertRR.getTextDirection(StructuredTextMethodsTest.toUT16("###"));
        dirH = expertRR.getTextDirection(StructuredTextMethodsTest.toUT16("ABC"));
        StructuredTextMethodsTest.assertTrue((String)"TestDirection #2", (dirA == 1 && dirH == 1 ? 1 : 0) != 0);
        IStructuredTextExpert expertLL = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)testMyCommaLL, (StructuredTextEnvironment)envLTR);
        String lean = StructuredTextMethodsTest.toUT16("ABC,#DEF,HOST,com");
        String full = expertLL.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #9 full", (String)"ABC@,#DEF@,HOST,com", (String)StructuredTextMethodsTest.toPseudo(full));
        lean = StructuredTextMethodsTest.toUT16("ABC,DEF,HOST,com");
        full = expertLL.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #10 full", (String)"ABC@,DEF@,HOST,com", (String)StructuredTextMethodsTest.toPseudo(full));
        StructuredTextEnvironment environment = new StructuredTextEnvironment(null, true, 0);
        IStructuredTextExpert expert = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)testMyCommaRL, (StructuredTextEnvironment)environment);
        dirA = expert.getTextDirection(StructuredTextMethodsTest.toUT16("###"));
        dirH = expert.getTextDirection(StructuredTextMethodsTest.toUT16("ABC"));
        StructuredTextMethodsTest.assertTrue((String)"TestDirection #10.5", (dirA == 1 && dirH == 0 ? 1 : 0) != 0);
        lean = StructuredTextMethodsTest.toUT16("ABC,#DEF,HOST,com");
        full = expert.leanToFullText(lean);
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #11 full", (String)"<&ABC,#DEF,HOST,com&^", (String)StructuredTextMethodsTest.toPseudo(full));
        String data = "ABc,#DEF,HOSt,COM";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        String model = "<&ABc,#DEF,HOSt,COM&^";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #12 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "ABc,#DEF,HOSt,";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = "<&ABc,#DEF,HOSt,&^";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #13 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "ABC,DEF,HOST,com";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = "ABC@,DEF@,HOST,com";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #14 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "--,---,----";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = "--,---,----";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #15 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "ABC,|DEF,HOST,com";
        lean = StructuredTextMethodsTest.toUT16(data);
        full = expert.leanToFullText(lean);
        model = "ABC,|DEF@,HOST,com";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #16 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        data = "ABc,|#DEF,HOST,com";
        lean = StructuredTextMethodsTest.toUT16(data);
        expert = StructuredTextExpertFactory.getStatefulExpert((StructuredTextTypeHandler)testMyCommaRL, (StructuredTextEnvironment)envRTLMIR);
        full = expert.leanToFullText(lean);
        model = "ABc,|#DEF,HOST,com";
        StructuredTextMethodsTest.assertEquals((String)"TestDirection #17 full", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
        int dir = expert.getTextDirection(lean);
        StructuredTextMethodsTest.assertEquals((String)"Test curDirection", (int)1, (int)dir);
    }

    public void testMethods() {
        this.doTestTools();
        this.doTestState();
        this.doTestOrientation();
        StructuredTextTypeHandler commaHandler = StructuredTextTypeHandlerFactory.getHandler((String)"comma");
        this.doTestOrient(commaHandler, "Methods #1 ", "", "", "", "");
        this.doTestOrient(commaHandler, "Methods #2 ", "abc", "abc", ">@abc@^", "abc");
        this.doTestOrient(commaHandler, "Methods #3 ", "ABC", "ABC", ">@ABC@^", "@ABC");
        this.doTestOrient(commaHandler, "Methods #4 ", "bcd,ef", "bcd,ef", ">@bcd,ef@^", "bcd,ef");
        this.doTestOrient(commaHandler, "Methods #5 ", "BCD,EF", "BCD@,EF", ">@BCD@,EF@^", "@BCD@,EF");
        this.doTestOrient(commaHandler, "Methods #6 ", "cde,FG", "cde,FG", ">@cde,FG@^", "cde,FG");
        this.doTestOrient(commaHandler, "Methods #7 ", "CDE,fg", "CDE,fg", ">@CDE,fg@^", "@CDE,fg");
        this.doTestOrient(commaHandler, "Methods #8 ", "12..def,GH", "12..def,GH", ">@12..def,GH@^", "12..def,GH");
        this.doTestOrient(commaHandler, "Methods #9 ", "34..DEF,gh", "34..DEF,gh", ">@34..DEF,gh@^", "@34..DEF,gh");
        this.doTestSkipProcessing();
        this.doTestLeanOffsets();
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 9;
        nArray[4] = 12;
        nArray[5] = 13;
        int[] nArray2 = new int[3];
        nArray2[1] = 4;
        nArray2[2] = 8;
        this.doTestFullOffsets("TestFullOffsets ", "BCD,EF,G", new int[]{3, 7}, nArray, nArray2);
        this.doTestMirrored();
        this.doTestDirection();
        IStructuredTextExpert expert = StructuredTextExpertFactory.getExpert((String)"comma");
        String data = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z";
        String lean = StructuredTextMethodsTest.toUT16(data);
        String full = expert.leanToFullText(lean);
        String model = "A@,B@,C@,D@,E@,F@,G@,H@,I@,J@,K@,L@,M@,N@,O@,P@,Q@,R@,S@,T@,U@,V@,W@,X@,Y@,Z";
        StructuredTextMethodsTest.assertEquals((String)"many inserts", (String)model, (String)StructuredTextMethodsTest.toPseudo(full));
    }

    private static class TestHandlerMyComma
    extends StructuredTextTypeHandler {
        private static final byte AL = 2;
        final int dirArabic;
        final int dirHebrew;

        public TestHandlerMyComma(int dirArabic, int dirHebrew) {
            this.dirArabic = dirArabic;
            this.dirHebrew = dirHebrew;
        }

        public String getSeparators(IStructuredTextExpert expert) {
            return ",";
        }

        public boolean skipProcessing(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes) {
            byte charType = charTypes.getBidiTypeAt(0);
            return charType == 2;
        }

        public int getDirection(IStructuredTextExpert expert, String text) {
            return this.getDirection(expert, text, new StructuredTextCharTypes(expert, text));
        }

        public int getDirection(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes) {
            int i = 0;
            while (i < text.length()) {
                byte charType = charTypes.getBidiTypeAt(i);
                if (charType == 2) {
                    return this.dirArabic;
                }
                ++i;
            }
            return this.dirHebrew;
        }
    }
}

