/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import java.util.Locale;
import org.eclipse.equinox.bidi.StructuredTextProcessor;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextExpertFactory;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;

public class StructuredTextProcessorTest
extends StructuredTextTestBase {
    private static final String HEBREW = "iw";
    private static final String HEBREW2 = "he";
    private static final String ARABIC = "ar";
    private static final String FARSI = "fa";
    private static final String URDU = "ur";
    private Locale locale;

    protected void setUp() throws Exception {
        super.setUp();
        this.locale = Locale.getDefault();
    }

    protected void tearDown() {
        Locale.setDefault(this.locale);
    }

    private void doTest1(String data, String result) {
        Locale.setDefault(Locale.ENGLISH);
        String full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full EN - ", (String)data, (String)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(HEBREW2));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full HE - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(ARABIC));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full AR - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(FARSI));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full FA - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(URDU));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full UR - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        Locale.setDefault(new Locale(HEBREW));
        full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data));
        String ful2 = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data), null);
        StructuredTextProcessorTest.assertEquals((String)"Util #1 full - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        StructuredTextProcessorTest.assertEquals((String)"Util #1 ful2 - ", (String)result, (String)StructuredTextProcessorTest.toPseudo(ful2));
        String lean = StructuredTextProcessor.deprocess((String)full);
        StructuredTextProcessorTest.assertEquals((String)"Util #1 lean - ", (String)data, (String)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest2(String msg, String data, String result) {
        this.doTest2(msg, data, result, data);
    }

    private void doTest2(String msg, String data, String result, String resLean) {
        String full = StructuredTextProcessor.process((String)StructuredTextProcessorTest.toUT16(data), (String)"*");
        StructuredTextProcessorTest.assertEquals((String)(String.valueOf(msg) + "full"), (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        String lean = StructuredTextProcessor.deprocess((String)full);
        StructuredTextProcessorTest.assertEquals((String)(String.valueOf(msg) + "lean"), (String)resLean, (String)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest3(String msg, String data, String result) {
        this.doTest3(msg, data, result, data);
    }

    private void doTest3(String msg, String data, String result, String resLean) {
        String full = StructuredTextProcessor.processTyped((String)StructuredTextProcessorTest.toUT16(data), (String)"comma");
        StructuredTextProcessorTest.assertEquals((String)(String.valueOf(msg) + "full"), (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
        String lean = StructuredTextProcessor.deprocessTyped((String)full, (String)"comma");
        StructuredTextProcessorTest.assertEquals((String)(String.valueOf(msg) + "lean"), (String)resLean, (String)StructuredTextProcessorTest.toPseudo(lean));
    }

    private void doTest4(String msg, String data, int[] offsets, int direction, int affixLength, String result) {
        String txt = String.valueOf(msg) + "text=" + data + "\n    offsets=" + StructuredTextProcessorTest.array_display(offsets) + "\n    direction=" + direction + "\n    affixLength=" + affixLength;
        String lean = StructuredTextProcessorTest.toUT16(data);
        IStructuredTextExpert expert = StructuredTextExpertFactory.getExpert();
        String full = expert.insertMarks(lean, offsets, direction, affixLength);
        StructuredTextProcessorTest.assertEquals((String)txt, (String)result, (String)StructuredTextProcessorTest.toPseudo(full));
    }

    public void testStructuredTextProcessor() {
        this.doTest1("ABC/DEF/G", ">@ABC@/DEF@/G@^");
        this.doTest2("Util #2.1 - ", "", "");
        this.doTest2("Util #2.2 - ", ">@ABC@^", ">@ABC@^", "ABC");
        this.doTest2("Util #2.3 - ", "abc", "abc");
        this.doTest2("Util #2.4 - ", "!abc", ">@!abc@^");
        this.doTest2("Util #2.5 - ", "abc!", ">@abc!@^");
        this.doTest2("Util #2.6 - ", "ABC*DEF*G", ">@ABC@*DEF@*G@^");
        this.doTest3("Util #3.1 - ", "ABC,DEF,G", ">@ABC@,DEF@,G@^");
        this.doTest3("Util #3.2 - ", "", "");
        this.doTest3("Util #3.3 - ", ">@DEF@^", ">@DEF@^", "DEF");
        this.doTest4("Util #4.1 - ", "ABCDEFG", new int[]{3, 6}, 0, 0, "ABC@DEF@G");
        this.doTest4("Util #4.2 - ", "ABCDEFG", new int[]{3, 6}, 0, 2, ">@ABC@DEF@G@^");
        this.doTest4("Util #4.3 - ", "ABCDEFG", new int[]{3, 6}, 1, 0, "ABC&DEF&G");
        this.doTest4("Util #4.4 - ", "ABCDEFG", new int[]{3, 6}, 1, 2, "<&ABC&DEF&G&^");
        this.doTest4("Util #4.5 - ", "", new int[]{3, 6}, 0, 0, "");
        this.doTest4("Util #4.6 - ", "", new int[]{3, 6}, 0, 2, "");
        this.doTest4("Util #4.7 - ", "ABCDEFG", null, 1, 0, "ABCDEFG");
        this.doTest4("Util #4.8 - ", "ABCDEFG", null, 1, 2, "<&ABCDEFG&^");
    }
}

