/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.internal.StructuredTextStringRecord;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;

public class StructuredTextStringRecordTest
extends StructuredTextTestBase {
    public void testStringRecord() {
        String str;
        StructuredTextStringRecord sr;
        boolean catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord(null, (int)1, (String)"email", (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch null string argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, null, (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch null handler argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)0, (String)"email", (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch invalid segment count argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)-1, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch invalid start argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)4, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch invalid start argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)0, (int)0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch invalid limit argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)0, (int)5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch invalid limit argument", (boolean)catchFlag);
        int poolSize = 100;
        int lim = poolSize / 2;
        sr = StructuredTextStringRecord.getRecord((String)"XXX");
        StructuredTextStringRecordTest.assertEquals(null, (Object)sr);
        int i = 0;
        while (i < lim) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.addRecord((String)str, (int)1, (String)"email", (int)0, (int)1);
            ++i;
        }
        sr = StructuredTextStringRecord.getRecord(null);
        StructuredTextStringRecordTest.assertEquals(null, (Object)sr);
        sr = StructuredTextStringRecord.getRecord((String)"");
        StructuredTextStringRecordTest.assertEquals(null, (Object)sr);
        i = 0;
        while (i < poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            if (i < lim) {
                StructuredTextStringRecordTest.assertFalse((sr == null ? 1 : 0) != 0);
            } else {
                StructuredTextStringRecordTest.assertTrue((sr == null ? 1 : 0) != 0);
            }
            ++i;
        }
        i = lim;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.addRecord((String)str, (int)1, (String)"email", (int)0, (int)1);
            ++i;
        }
        i = 1;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            StructuredTextStringRecordTest.assertFalse((sr == null ? 1 : 0) != 0);
            ++i;
        }
        sr = StructuredTextStringRecord.getRecord((String)"0");
        StructuredTextStringRecordTest.assertEquals(null, (Object)sr);
        sr = StructuredTextStringRecord.addRecord((String)"thisisalongstring", (int)3, (String)"email", (int)0, (int)2);
        sr.addSegment("java", 4, 5);
        sr.addSegment("file", 6, 7);
        catchFlag = false;
        try {
            sr.addSegment("email", 10, 13);
        }
        catch (IllegalStateException illegalStateException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch too many segments", (boolean)catchFlag);
        StructuredTextStringRecordTest.assertEquals((int)3, (int)sr.getSegmentCount());
        StructuredTextStringRecordTest.assertEquals((String)"email", (String)sr.getHandler(0));
        StructuredTextStringRecordTest.assertEquals((String)"java", (String)sr.getHandler(1));
        StructuredTextStringRecordTest.assertEquals((String)"file", (String)sr.getHandler(2));
        StructuredTextStringRecordTest.assertEquals((int)0, (int)sr.getStart(0));
        StructuredTextStringRecordTest.assertEquals((int)4, (int)sr.getStart(1));
        StructuredTextStringRecordTest.assertEquals((int)6, (int)sr.getStart(2));
        StructuredTextStringRecordTest.assertEquals((int)2, (int)sr.getLimit(0));
        StructuredTextStringRecordTest.assertEquals((int)5, (int)sr.getLimit(1));
        StructuredTextStringRecordTest.assertEquals((int)7, (int)sr.getLimit(2));
        catchFlag = false;
        try {
            sr.getLimit(3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        StructuredTextStringRecordTest.assertTrue((String)"Catch segment number too large", (boolean)catchFlag);
        StructuredTextStringRecord.clear();
        i = 0;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            StructuredTextStringRecordTest.assertEquals(null, (Object)sr);
            ++i;
        }
    }
}

