/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.coordinator.CoordinationPermissionCollection;
import org.osgi.service.coordinator.SignerProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoordinationPermission
extends BasicPermission {
    private static final long serialVersionUID = 1L;
    public static final String INITIATE = "initiate";
    public static final String PARTICIPATE = "participate";
    public static final String ADMIN = "admin";
    private static final int ACTION_INITIATE = 1;
    private static final int ACTION_PARTICIPATE = 2;
    private static final int ACTION_ADMIN = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public CoordinationPermission(String filter, String actions) {
        this(CoordinationPermission.parseFilter(filter), CoordinationPermission.parseActions(actions));
    }

    public CoordinationPermission(String coordinationName, Bundle coordinationBundle, String actions) {
        super(coordinationName);
        this.setTransients(null, CoordinationPermission.parseActions(actions));
        this.bundle = coordinationBundle;
        if (coordinationName == null) {
            throw new NullPointerException("coordinationName must not be null");
        }
        if (coordinationBundle == null) {
            throw new NullPointerException("coordinationBundle must not be null");
        }
    }

    CoordinationPermission(Filter filter, int mask) {
        super(filter == null ? "*" : filter.toString());
        this.setTransients(filter, mask);
        this.bundle = null;
    }

    private void setTransients(Filter filter, int mask) {
        this.filter = filter;
        if (mask == 0 || (mask & 7) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl37
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 4 || a[i - 4] != 'a' && a[i - 4] != 'A' || a[i - 3] != 'd' && a[i - 3] != 'D' || a[i - 2] != 'm' && a[i - 2] != 'M' || a[i - 1] != 'i' && a[i - 1] != 'I' || a[i] != 'n' && a[i] != 'N')) {
                    matchlen = 5;
                    mask |= 4;
                } else if (!(i < 7 || a[i - 7] != 'i' && a[i - 7] != 'I' || a[i - 6] != 'n' && a[i - 6] != 'N' || a[i - 5] != 'i' && a[i - 5] != 'I' || a[i - 4] != 't' && a[i - 4] != 'T' || a[i - 3] != 'i' && a[i - 3] != 'I' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 8;
                    mask |= 1;
                } else if (!(i < 10 || a[i - 10] != 'p' && a[i - 10] != 'P' || a[i - 9] != 'a' && a[i - 9] != 'A' || a[i - 8] != 'r' && a[i - 8] != 'R' || a[i - 7] != 't' && a[i - 7] != 'T' || a[i - 6] != 'i' && a[i - 6] != 'I' || a[i - 5] != 'c' && a[i - 5] != 'C' || a[i - 4] != 'i' && a[i - 4] != 'I' || a[i - 3] != 'p' && a[i - 3] != 'P' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 11;
                    mask |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl37:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    private static Filter parseFilter(String filterString) {
        if ((filterString = filterString.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid filter");
            iae.initCause(e);
            throw iae;
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission requested = (CoordinationPermission)p;
        if (this.bundle != null) {
            return false;
        }
        if (requested.filter != null) {
            return false;
        }
        return this.implies0(requested, 0);
    }

    boolean implies0(CoordinationPermission requested, int effective) {
        int desired = requested.action_mask;
        if (((effective |= this.action_mask) & desired) != desired) {
            return false;
        }
        Filter f = this.filter;
        if (f == null) {
            return true;
        }
        return f.matches(requested.getProperties());
    }

    @Override
    public String getActions() {
        String result = this.actions;
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            int mask = this.action_mask;
            if ((mask & 4) == 4) {
                sb.append(ADMIN);
                comma = true;
            }
            if ((mask & 1) == 1) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(INITIATE);
                comma = true;
            }
            if ((mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(PARTICIPATE);
                comma = true;
            }
            this.actions = result = sb.toString();
        }
        return result;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new CoordinationPermissionCollection();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission cp = (CoordinationPermission)obj;
        return this.action_mask == cp.action_mask && this.getName().equals(cp.getName()) && (this.bundle == cp.bundle || this.bundle != null && this.bundle.equals(cp.bundle));
    }

    @Override
    public int hashCode() {
        int h = 527 + this.getName().hashCode();
        h = 31 * h + this.getActions().hashCode();
        if (this.bundle != null) {
            h = 31 * h + this.bundle.hashCode();
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setTransients(CoordinationPermission.parseFilter(this.getName()), CoordinationPermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> result = this.properties;
        if (result != null) {
            return result;
        }
        final HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("coordination.name", this.getName());
        if (this.bundle != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SignerProperty signer;
                    map.put("id", new Long(CoordinationPermission.this.bundle.getBundleId()));
                    map.put("location", CoordinationPermission.this.bundle.getLocation());
                    String name = CoordinationPermission.this.bundle.getSymbolicName();
                    if (name != null) {
                        map.put("name", name);
                    }
                    if ((signer = new SignerProperty(CoordinationPermission.this.bundle)).isBundleSigned()) {
                        map.put("signer", signer);
                    }
                    return null;
                }
            });
        }
        this.properties = map;
        return this.properties;
    }
}

