/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.tests.tbc;

public class DSEvent
implements Comparable {
    public static final int ACT_BOUND = 1;
    public static final int ACT_UNBOUND = 2;
    public static final int ACT_ACTIVATE = 3;
    public static final int ACT_DEACTIVATE = 4;
    private static long lastTime = System.currentTimeMillis();
    private static final Object lock = new Object();
    private long time;
    private int action;
    private Object object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSEvent(int action, Object object) {
        Object object2 = lock;
        synchronized (object2) {
            this.action = action;
            this.object = object;
            while (lastTime == System.currentTimeMillis()) {
            }
            this.time = lastTime = System.currentTimeMillis();
        }
    }

    public int getAction() {
        return this.action;
    }

    public Object getObject() {
        return this.object;
    }

    public long getTime() {
        return this.time;
    }

    public boolean before(DSEvent event) {
        return event.time > this.time;
    }

    public int compareTo(Object var0) {
        DSEvent event = (DSEvent)var0;
        if (event.time > this.time) {
            return -1;
        }
        if (event.time < this.time) {
            return 1;
        }
        return 0;
    }

    protected String getActionAsString() {
        switch (this.getAction()) {
            case 1: {
                return "ACT_BOUND";
            }
            case 2: {
                return "ACT_UNBOUND";
            }
            case 3: {
                return "ACT_ACTIVATE";
            }
            case 4: {
                return "ACT_DEACTIVATE";
            }
        }
        return "UNKNOWN (" + this.getAction() + ")";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DSEvent[");
        buf.append("time=" + this.time + ";action=");
        buf.append(this.getActionAsString());
        buf.append(";object=" + (this.object != null ? this.object.toString() : "null"));
        buf.append("]");
        return buf.toString();
    }
}

