/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public abstract class FwkAdminAndSimpleConfiguratorTest
extends AbstractFwkAdminTest {
    private File installFolder;
    private File configurationFolder;
    private String launcherName;

    public FwkAdminAndSimpleConfiguratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startSimpleConfiguratorManipulator();
    }

    protected Manipulator getNewManipulator(String workArea) throws FrameworkAdminRuntimeException, IOException, BundleException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        this.installFolder = this.getTestFolder(workArea, false);
        this.configurationFolder = new File(this.installFolder, "configuration");
        this.launcherName = "eclipse";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.configurationFolder);
        launcherData.setLauncher(new File(this.installFolder, this.launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        return manipulator;
    }

    protected Manipulator createMinimalConfiguration(String workArea) throws Exception {
        Manipulator manipulator = this.getNewManipulator(workArea);
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        try {
            manipulator.save(false);
        }
        catch (IOException iOException) {
            FwkAdminAndSimpleConfiguratorTest.fail((String)"Error while persisting");
        }
        catch (FrameworkAdminRuntimeException frameworkAdminRuntimeException) {
            FwkAdminAndSimpleConfiguratorTest.fail((String)"Error while persisting");
        }
        return manipulator;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.installFolder != null) {
            FwkAdminAndSimpleConfiguratorTest.delete(this.installFolder);
        }
    }

    public File getInstallFolder() {
        return this.installFolder;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    public File getBundleTxt() {
        return new File(this.configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info");
    }

    public File getConfigIni() {
        return new File(this.configurationFolder, "config.ini");
    }

    public String getLauncherName() {
        return this.launcherName;
    }
}

