/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class LauncherConfigLocationTest
extends AbstractFwkAdminTest {
    public LauncherConfigLocationTest(String name) {
        super(name);
    }

    public void testCustomLauncherConfig() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException, URISyntaxException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(LauncherConfigLocationTest.class.getName());
        if (installFolder.exists()) {
            LauncherConfigLocationTest.delete(installFolder);
        }
        File configurationFolder = new File(installFolder, "configuration");
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        LauncherConfigLocationTest.assertNotNull((String)("Null launcher data" + launcherData), (Object)launcherData);
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        File defaultlaunchConfig = new File(installFolder, String.valueOf(launcherName) + ".ini");
        LauncherConfigLocationTest.assertEquals((boolean)defaultlaunchConfig.exists(), (boolean)false);
        File launchConfig = new File(installFolder, "mylaunch.ini");
        LauncherConfigLocationTest.assertEquals((boolean)launchConfig.exists(), (boolean)false);
        launcherData.setLauncherConfigLocation(launchConfig);
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        LauncherConfigLocationTest.assertEquals((boolean)launchConfig.exists(), (boolean)true);
        LauncherConfigLocationTest.assertEquals((boolean)defaultlaunchConfig.exists(), (boolean)false);
    }
}

