/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class MacOSLikeSetup
extends FwkAdminAndSimpleConfiguratorTest {
    public MacOSLikeSetup(String name) {
        super(name);
    }

    public void testMacOSSetup() throws FrameworkAdminRuntimeException, IOException, BundleException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = new File(Activator.getContext().getDataFile(MacOSLikeSetup.class.getName()), "eclipse");
        File configurationFolder = new File(installFolder, "configuration");
        File launcherFolder = new File(installFolder, "Eclipse.app/Contents/MacOS/");
        File launcherName = new File(launcherFolder, "eclipse");
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(launcherName);
        launcherData.setLauncherConfigLocation(new File(launcherFolder, "eclipse.ini"));
        launcherData.setOS("macosx");
        File osgiJar = new File(installFolder, "plugins/org.eclipse.osgi.jar");
        File scJar = new File(installFolder, "plugins/org.eclipse.equinox.simpleconfigurator.jar");
        File launcherJar = new File(installFolder, "plugins/org.eclipse.equinox.launcher.jar");
        MacOSLikeSetup.copy("OSGi", new File(FileLocator.toFileURL((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar")).getPath()), osgiJar);
        MacOSLikeSetup.copy("SC", new File(FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar")).getPath()), scJar);
        MacOSLikeSetup.copy("Startup", new File(FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.launcher.jar")).getPath()), launcherJar);
        manipulator.getConfigData().addBundle(new BundleInfo(osgiJar.toURI()));
        manipulator.getConfigData().addBundle(new BundleInfo(scJar.toURI(), 1, true));
        manipulator.getConfigData().addBundle(new BundleInfo(launcherJar.toURI()));
        manipulator.getLauncherData().addProgramArg("-startup");
        manipulator.getLauncherData().addProgramArg(launcherJar.toURI().toString());
        manipulator.getLauncherData().setFwJar(osgiJar);
        try {
            manipulator.save(false);
        }
        catch (IllegalStateException illegalStateException) {}
        File launcherIni = new File(launcherFolder, "eclipse.ini");
        this.assertNotContent(launcherIni, "-configuration");
        this.assertNotContent(launcherIni, "-install");
        this.assertContent(launcherIni, "-startup");
        this.assertContent(launcherIni, "../../../plugins/org.eclipse.equinox.launcher.jar");
        this.assertNotContent(launcherIni, MacOSLikeSetup.class.getName());
        this.assertNotContent(new File(configurationFolder, "config.ini"), MacOSLikeSetup.class.getName());
        MacOSLikeSetup.assertTrue((String)"bundles.info missing", (boolean)new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info").exists());
    }

    public void testMacWithoutStartupOrFw() throws Exception {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = new File(Activator.getContext().getDataFile(MacOSLikeSetup.class.getName()), "eclipse");
        File configurationFolder = new File(installFolder, "configuration");
        File launcherFolder = new File(installFolder, "Eclipse.app/Contents/MacOS/");
        File launcherName = new File(launcherFolder, "eclipse");
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(launcherName);
        launcherData.setOS("macosx");
        File osgiJar = new File(installFolder, "plugins/org.eclipse.osgi.jar");
        File scJar = new File(installFolder, "plugins/org.eclipse.equinox.simpleconfigurator.jar");
        File bundle = new File(installFolder, "plugins/bundle_1");
        MacOSLikeSetup.copy("OSGi", new File(FileLocator.toFileURL((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar")).getPath()), osgiJar);
        MacOSLikeSetup.copy("SC", new File(FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar")).getPath()), scJar);
        MacOSLikeSetup.copy("bundle", new File(FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1")).getPath()), bundle);
        manipulator.getConfigData().addBundle(new BundleInfo(osgiJar.toURI()));
        manipulator.getConfigData().addBundle(new BundleInfo(scJar.toURI(), 1, true));
        manipulator.getConfigData().addBundle(new BundleInfo(bundle.toURI()));
        manipulator.save(false);
        File launcherIni = new File(launcherFolder, "eclipse.ini");
        File bundleInfo = new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.assertNotContent(launcherIni, "-configuration");
        this.assertNotContent(launcherIni, "../../../configuration");
        this.assertContent(bundleInfo, "file:plugins/bundle_1/");
    }
}

