/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class ReaderTest2
extends AbstractFwkAdminTest {
    private File installFolder = null;
    private File configurationFolder = null;
    private String launcherName = "eclipse";

    public ReaderTest2(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startSimpleConfiguratorManipulator();
        this.installFolder = Activator.getContext().getDataFile(ReaderTest2.class.getName());
        this.configurationFolder = new File(this.installFolder, "conf");
        this.writeEclipseIni(new File(this.installFolder, "eclipse.ini"), new String[]{"-configuration", this.configurationFolder.getAbsolutePath()});
        Properties properties = new Properties();
        properties.setProperty("foo", "bar");
        this.writeConfigIni(new File(this.configurationFolder, "config.ini"), properties);
    }

    public void testConfigContent() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setLauncher(new File(this.installFolder, this.launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        ReaderTest2.assertEquals((Object)new File(this.installFolder, "conf"), (Object)manipulator.getLauncherData().getFwConfigLocation());
        ReaderTest2.assertEquals((String)"bar", (String)manipulator.getConfigData().getProperty("foo"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

