/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class SimpleConfiguratorTest
extends AbstractFwkAdminTest {
    public SimpleConfiguratorTest(String name) {
        super(name);
    }

    public void testConfigFiles() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException, URISyntaxException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(SimpleConfiguratorTest.class.getName());
        File configurationFolder = new File(installFolder, "configuration");
        String launcherName = "eclipse";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        File bundleTXT = new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        File configINI = new File(configurationFolder, "config.ini");
        this.assertContent(bundleTXT, "org.eclipse.osgi");
        this.assertContent(configINI, "org.eclipse.osgi");
        this.assertContent(bundleTXT, "org.eclipse.equinox.simpleconfigurator");
        this.assertContent(configINI, "org.eclipse.equinox.simpleconfigurator");
    }

    public void testBundleInfoEquals() throws Exception {
        BundleInfo b1 = new BundleInfo("org.foo", "3.1.0", new URI("plugins/org.foo_3.1.0"), -1, false);
        BundleInfo b2 = new BundleInfo("org.foo", "3.1.0", null, -1, false);
        BundleInfo b3 = new BundleInfo("org.foo", "3.1.0", URIUtil.fromString((String)"C:/sp ace/plugins/org.foo_3.1.0"), -1, false);
        SimpleConfiguratorTest.assertEquals((Object)b1, (Object)b2);
        SimpleConfiguratorTest.assertFalse((boolean)b1.equals((Object)b3));
        b1.setBaseLocation(URIUtil.fromString((String)"C:/sp ace"));
        SimpleConfiguratorTest.assertEquals((Object)b1, (Object)b3);
        b3.setBaseLocation(URIUtil.fromString((String)"C:/sp ace"));
        SimpleConfiguratorTest.assertEquals((Object)b1, (Object)b3);
        b3.setVersion(null);
        b1.setVersion("0.0.0");
        SimpleConfiguratorTest.assertEquals((Object)b1, (Object)b3);
    }
}

