/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.frameworkadmin.tests.TestEclipseDataArea;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;

public class TestVMArg
extends FwkAdminAndSimpleConfiguratorTest {
    private Manipulator m;

    public TestVMArg(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(TestEclipseDataArea.class.getName());
    }

    public void testVMInsideInstall() throws FrameworkAdminRuntimeException, IOException {
        File jreLocation = new File(this.m.getLauncherData().getLauncher().getParentFile(), "jre");
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertNotContent(new File(this.getInstallFolder(), "eclipse.ini"), jreLocation.getAbsolutePath());
        this.assertContent(new File(this.getInstallFolder(), "eclipse.ini"), "jre");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        TestVMArg.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
        this.m.getLauncherData().setJvm(null);
        this.m.save(false);
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
    }

    public void testVMOutsideInstall() throws FrameworkAdminRuntimeException, IOException {
        File jreLocation = new File(this.m.getLauncherData().getLauncher().getParentFile(), "../../jre").getCanonicalFile();
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertContent(new File(this.getInstallFolder(), "eclipse.ini"), jreLocation.getAbsolutePath().replace('\\', '/'));
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        TestVMArg.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
    }

    public void test269502() throws FrameworkAdminRuntimeException, IOException {
        String winPath = "c:/ibm5sr3/bin";
        String linuxPath = "/Users/Pascal/ibm5sr3/bin";
        String chosenPath = Platform.getOS().equals("win32") ? winPath : linuxPath;
        File jreLocation = new File(chosenPath);
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertContent(new File(this.getInstallFolder(), "eclipse.ini"), chosenPath);
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), chosenPath);
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        TestVMArg.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
    }

    public void test282303() throws FrameworkAdminRuntimeException, IOException {
        this.assertNotContent(new File(this.getInstallFolder(), "eclipse.ini"), "-vm");
        this.assertNotContent(new File(this.getInstallFolder(), "eclipse.ini"), "../mylocation");
        this.assertNotContent(new File(this.getInstallFolder(), "eclipse.ini"), "-otherarg");
        this.m.getLauncherData().addProgramArg("-vm");
        this.m.getLauncherData().addProgramArg("../mylocation");
        this.m.getLauncherData().addProgramArg("-otherarg");
        this.m.getLauncherData().setJvm(new File("../mylocation"));
        this.m.save(false);
        this.m.load();
        String[] args = this.m.getLauncherData().getProgramArgs();
        boolean found = false;
        int i = 0;
        while (i < args.length) {
            if ("-vm".equals(args[i]) && i != args.length - 1 && "../mylocation".equals(args[++i])) {
                found = true;
                break;
            }
            ++i;
        }
        TestVMArg.assertTrue((String)"Can't find vm argument.", (boolean)found);
    }
}

