/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;

public class UtilsTest
extends AbstractFwkAdminTest {
    public UtilsTest(String name) {
        super(name);
    }

    public void test_getEclipseRealLocation() throws Exception {
        File installFolder = Activator.getContext().getDataFile("212361");
        File plugins = new File(installFolder, "plugins");
        File foo1 = new File(plugins, "org.foo_1.2.3.abc");
        File foo2 = new File(plugins, "org.foo_1.2.4.xyz");
        File foo_64 = new File(plugins, "org.foo.x86_64_1.2.3");
        File fooWithSpaces = new File(plugins, "alotof/s p a c e s/org.foo_1.2.3.abc");
        foo1.mkdirs();
        foo2.mkdirs();
        foo_64.mkdirs();
        fooWithSpaces.mkdirs();
        Manipulator manipulator = this.getFrameworkManipulator(new File(installFolder, "configuration"), new File(installFolder, "eclipse"));
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)"org.foo"), (Object)foo2.toURI());
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)"org.foo_1.2.3.abc"), (Object)foo1.toURI());
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)"org.foo.x86_64"), (Object)foo_64.toURI());
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)(String.valueOf(plugins.toURI().toString()) + "alotof/s%20p%20a%20c%20e%20s/org.foo_1.2.3.abc/")), (Object)fooWithSpaces.toURI());
        File other = new File(installFolder, "other/org.foo_1.2.4");
        other.mkdirs();
        manipulator.getConfigData().setProperty("osgi.syspath", other.getParentFile().getAbsolutePath());
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)"org.foo"), (Object)other.toURI());
    }

    public void testMacRealLocation() throws Exception {
        File installFolder = Activator.getContext().getDataFile("280007");
        File plugins = new File(installFolder, "plugins");
        File foo = new File(plugins, "org.foo_1.2.3.abc");
        foo.mkdirs();
        Manipulator manipulator = this.getFrameworkManipulator(new File(installFolder, "configuration"), new File(installFolder, "Eclipse.app/Contents/MacOS/eclipse"));
        manipulator.getLauncherData().setOS("macosx");
        UtilsTest.assertEquals((Object)FileUtils.getEclipseRealLocation((Manipulator)manipulator, (String)"org.foo"), (Object)foo.toURI());
    }
}

