/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.discovery.tests.DiscoveryTestConstants;

public class RemoteBundleDiscoveryStrategyTest
extends TestCase {
    private RemoteBundleDiscoveryStrategy discoveryStrategy;

    protected void setUp() throws Exception {
        this.discoveryStrategy = new RemoteBundleDiscoveryStrategy();
        this.discoveryStrategy.setDirectoryUrl(DiscoveryTestConstants.DISCOVERY_URL);
        this.discoveryStrategy.setCategories(new ArrayList());
        this.discoveryStrategy.setItems(new ArrayList());
        this.discoveryStrategy.setCertifications(new ArrayList());
        this.discoveryStrategy.setTags(new ArrayList());
    }

    public void testPerformDiscovery() throws CoreException, IOException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        RemoteBundleDiscoveryStrategyTest.assertFalse((boolean)this.discoveryStrategy.getCategories().isEmpty());
        for (CatalogCategory category : this.discoveryStrategy.getCategories()) {
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getId());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getName());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getDescription());
        }
        RemoteBundleDiscoveryStrategyTest.assertFalse((boolean)this.discoveryStrategy.getItems().isEmpty());
        for (CatalogItem connector : this.discoveryStrategy.getItems()) {
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getId());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getTags());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getName());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getDescription());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getSource());
            URL pluginXmlUrl = connector.getSource().getResource("plugin.xml");
            InputStream in = pluginXmlUrl.openStream();
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)in);
            in.close();
        }
    }
}

