/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core.util;

import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.util.CatalogCategoryComparator;

public class CatalogCategoryComparatorTest
extends TestCase {
    private CatalogCategoryComparator comparator;
    private CatalogCategory category1;
    private CatalogCategory category2;

    protected void setUp() throws Exception {
        super.setUp();
        this.comparator = new CatalogCategoryComparator();
        this.category1 = new CatalogCategory();
        this.category2 = new CatalogCategory();
    }

    public void testSortByRelevanceInequal() {
        this.category1.setRelevance("100");
        this.category2.setRelevance("50");
        CatalogCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        CatalogCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceOneNotSpecified() {
        this.category1.setRelevance("10");
        CatalogCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        CatalogCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSame() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("1");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("1");
        CatalogCategoryComparatorTest.assertEquals((int)0, (int)this.comparator.compare(this.category1, this.category2));
        CatalogCategoryComparatorTest.assertEquals((int)0, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSameIdsDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("b");
        CatalogCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        CatalogCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSameNamesDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("a");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("b");
        this.category2.setId("a");
        CatalogCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        CatalogCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }
}

