/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core.util;

import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.discovery.compatibility.util.TransportUtil;

public class TransportUtilTest
extends TestCase {
    public void testGetFileNameForJar() throws Exception {
        TransportUtilTest.assertEquals((String)"lib_1.0.jar", (String)TransportUtil.getFileNameFor((String)"lib-1.0.jar"));
    }

    public void testGetFileNameForUrl() throws Exception {
        TransportUtilTest.assertEquals((String)"lib_1.0.jar", (String)TransportUtil.getFileNameFor((String)"http://www.eclipse.org/downloads/download.php?file=/discovery/lib-1.0.jar"));
    }

    public void testGetFileNameForUrlWithQuery() throws Exception {
        TransportUtilTest.assertEquals((String)"lib_1.0.jar_r_1_protocol_http", (String)TransportUtil.getFileNameFor((String)"http://www.eclipse.org/downloads/download.php?file=/discovery/lib-1.0.jar&r=1&protocol=http"));
    }

    public void testGetFileNameForUrlEndingWithSlash() throws Exception {
        TransportUtilTest.assertEquals((String)"a.jar", (String)TransportUtil.getFileNameFor((String)"a.jar/"));
    }

    public void testGetFileNameForUrlWithFilesystemReservedCharacters() throws Exception {
        TransportUtilTest.assertEquals((String)"1_2_3_4_5_6_7_8_9_", (String)TransportUtil.getFileNameFor((String)"1<2>3:4\"5\\6|7?8*9+"));
    }
}

