/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.VersionIncompatibleException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExportTests
extends AbstractProvisioningTest {
    private P2ImportExport importexportService;

    private List<IStatus> getChildren(IStatus s) {
        ArrayList<IStatus> rt = new ArrayList<IStatus>();
        if (s.isMultiStatus()) {
            IStatus[] iStatusArray = s.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                rt.addAll(this.getChildren(child));
                ++n2;
            }
        }
        rt.add(s);
        return rt;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ServiceTracker tracker = new ServiceTracker(TestActivator.getContext(), P2ImportExport.class, null);
        tracker.open();
        this.importexportService = (P2ImportExport)tracker.getService();
        ImportExportTests.assertNotNull((String)"Fail to get ImportExport service", (Object)this.importexportService);
        tracker.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.importexportService = null;
    }

    public void testLoadP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/test.p2f");
        FileInputStream input = new FileInputStream(p2fFile);
        try {
            List iuDetails = this.importexportService.importP2F((InputStream)input);
            ImportExportTests.assertTrue((String)"Should load two features from the p2f file.", (iuDetails.size() == 2 ? 1 : 0) != 0);
            int counter = 0;
            for (IUDetail iu : iuDetails) {
                if ("org.polarion.eclipse.team.svn.connector.feature.group".equals(iu.getIU().getId())) {
                    ++counter;
                    ImportExportTests.assertTrue((String)"Should have two referred repository.", (iu.getReferencedRepositories().size() == 2 ? 1 : 0) != 0);
                    continue;
                }
                if (!"org.polarion.eclipse.team.svn.connector.svnkit16.feature.group".equals(iu.getIU().getId())) continue;
                ++counter;
                ImportExportTests.assertTrue((String)"Should have one referred repository", (iu.getReferencedRepositories().size() == 1 ? 1 : 0) != 0);
            }
            ImportExportTests.assertEquals((String)"Load unexpected content.", (int)2, (int)counter);
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public void testLoadUnknownP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/unknownformat.p2f");
        FileInputStream input = new FileInputStream(p2fFile);
        try {
            List iuDetails = this.importexportService.importP2F((InputStream)input);
            ImportExportTests.assertEquals((String)"Should not load any detail.", (int)0, (int)iuDetails.size());
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public void testIncompatibleP2f() throws IOException {
        File p2fFile = ImportExportTests.getTestData((String)"Error load test file.", (String)"testData/importexport/incompatible.p2f");
        FileInputStream input = new FileInputStream(p2fFile);
        try {
            try {
                this.importexportService.importP2F((InputStream)input);
                ImportExportTests.assertTrue((String)"Didn't complain the given file is not supported by current version.", (boolean)false);
            }
            catch (VersionIncompatibleException versionIncompatibleException) {
                ((InputStream)input).close();
            }
        }
        finally {
            ((InputStream)input).close();
        }
    }

    public void testExportFeaturesInstalledFromLocal() throws ProvisionException, OperationCanceledException, IOException {
        File testFile = File.createTempFile("test", "p2f");
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportTests.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
            File localRepoFile = ImportExportTests.getTestData((String)"Error load data", (String)"testData/importexport/repo1");
            IMetadataRepository repo = metaManager.loadRepository(localRepoFile.toURI(), null);
            ImportExportTests.assertNotNull((String)"Fail to load local repo", (Object)repo);
            IInstallableUnit iu = ImportExportTests.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            FileOutputStream output = new FileOutputStream(testFile);
            IStatus status = this.importexportService.exportP2F((OutputStream)output, new IInstallableUnit[]{iu}, false, null);
            ImportExportTests.assertFalse((String)"Not expected return result.", (boolean)status.isOK());
            ImportExportTests.assertTrue((String)"Should be a multiple status", (boolean)status.isMultiStatus());
            boolean hasFeaturesIgnored = false;
            for (IStatus s : this.getChildren(status)) {
                if (s.getCode() != 1) continue;
                hasFeaturesIgnored = true;
            }
            ImportExportTests.assertTrue((String)"Should have features ignored due to they're installed from local repository.", (boolean)hasFeaturesIgnored);
            ((OutputStream)output).close();
        }
        finally {
            testFile.delete();
        }
    }

    public void testAllowExportFeaturesInstalledFromLocal() throws ProvisionException, OperationCanceledException, IOException {
        File testFile = File.createTempFile("test", "p2f");
        try {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)ImportExportTests.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
            File localRepoFile = ImportExportTests.getTestData((String)"Error load data", (String)"testData/importexport/repo1");
            IMetadataRepository repo = metaManager.loadRepository(localRepoFile.toURI(), null);
            ImportExportTests.assertNotNull((String)"Fail to load local repo", (Object)repo);
            IInstallableUnit iu = ImportExportTests.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
            FileOutputStream output = new FileOutputStream(testFile);
            IStatus status = this.importexportService.exportP2F((OutputStream)output, new IInstallableUnit[]{iu}, true, null);
            ImportExportTests.assertTrue((boolean)status.isOK());
            ((OutputStream)output).close();
        }
        finally {
            testFile.delete();
        }
    }
}

