/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.RemediationPage;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class InstallWithRemediationTest
extends WizardTest {
    private static final String AVAILABLE_SOFTWARE_PAGE = "AvailableSoftwarePage";
    IInstallableUnit toInstall;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: TopLevelIU = 1")
    public IInstallableUnit anotherIUToInstall;

    protected void setUp() throws Exception {
        super.setUp();
        IULoader.loadIUs((Object)((Object)this));
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("TopLevelIU");
        iu.setProperty("org.eclipse.equinox.p2.type.group", "true");
        iu.setVersion(Version.createOSGi((int)2, (int)0, (int)0));
        iu.setSingleton(true);
        iu.setLicenses(new ILicense[]{new License(null, "There is a license to accept!", null)});
        iu.setCapabilities(new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"TopLevelIU", (Version)iu.getVersion())});
        this.toInstall = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.toInstall, this.anotherIUToInstall});
    }

    public void testInstallWizardUnresolved() {
        LoadMetadataRepositoryJob job = new LoadMetadataRepositoryJob(this.getProvisioningUI());
        this.getPolicy().setGroupByCategory(false);
        job.runModal(this.getMonitor());
        InstallWizard wizard = new InstallWizard(this.getProvisioningUI(), null, null, job);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(false);
        dialog.open();
        Object longOp = null;
        try {
            AvailableIUsPage page1 = (AvailableIUsPage)wizard.getPage(AVAILABLE_SOFTWARE_PAGE);
            InstallWithRemediationTest.assertTrue((String)"1.0", (page1.getSelectedIUs().size() == 0 ? 1 : 0) != 0);
            InstallWithRemediationTest.assertFalse((String)"1.1", (boolean)page1.isPageComplete());
            AvailableIUGroup group = page1.testGetAvailableIUGroup();
            group.setRepositoryFilter(1, null);
            DeferredQueryContentProvider provider = (DeferredQueryContentProvider)group.getCheckboxTreeViewer().getContentProvider();
            provider.setSynchronous(true);
            group.getCheckboxTreeViewer().refresh();
            group.getCheckboxTreeViewer().expandAll();
            Tree tree = (Tree)group.getCheckboxTreeViewer().getControl();
            TreeItem[] items = tree.getItems();
            int i = 0;
            while (i < items.length) {
                Object element = items[i].getData();
                if (element != null && element instanceof IIUElement) {
                    IInstallableUnit iu = ((IIUElement)element).getIU();
                    if (iu != null && iu.getId().equals("TopLevelIU")) {
                        group.getCheckboxTreeViewer().setChecked(element, true);
                    }
                    if (iu != null && iu.getId().equals("egit")) {
                        group.getCheckboxTreeViewer().setChecked(element, true);
                    }
                }
                ++i;
            }
            group.setChecked(group.getCheckboxTreeViewer().getCheckedElements());
            InstallWithRemediationTest.assertTrue((String)"2.0", (group.getCheckedLeafIUs().length > 0 ? 1 : 0) != 0);
            InstallWithRemediationTest.assertTrue((String)"2.1", (boolean)page1.isPageComplete());
            IWizardPage remediationPage = wizard.getNextPage((IWizardPage)page1);
            dialog.showPage(remediationPage);
            InstallWithRemediationTest.assertTrue((boolean)(remediationPage instanceof RemediationPage));
            InstallWithRemediationTest.assertTrue((String)"3.0", (boolean)remediationPage.isPageComplete());
            IWizardPage previousPage = wizard.getPreviousPage(remediationPage);
            dialog.showPage(previousPage);
            remediationPage = wizard.getNextPage((IWizardPage)page1);
            dialog.showPage(remediationPage);
        }
        finally {
            dialog.close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }
}

