/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.ui.query.AvailableIUWrapperTest;

public class LatestIUVersionElementWrapperTest
extends AvailableIUWrapperTest {
    protected IInstallableUnit getIU(Object collected) {
        if (collected instanceof IInstallableUnit) {
            return (IInstallableUnit)collected;
        }
        return ((IIUElement)collected).getIU();
    }

    public void testCollectLatestIU() {
        IQuery latestIuVersionElementQuery = QueryUtil.createLatestIUQuery();
        IInstallableUnit unit1 = LatestIUVersionElementWrapperTest.createIU((String)"f1", (Version)Version.createOSGi((int)1, (int)0, (int)0));
        IInstallableUnit unit2 = LatestIUVersionElementWrapperTest.createIU((String)"f1", (Version)Version.createOSGi((int)1, (int)0, (int)1));
        ArrayList<IInstallableUnit> listOfIUs = new ArrayList<IInstallableUnit>();
        listOfIUs.add(unit1);
        listOfIUs.add(unit2);
        IQueryResult collector = latestIuVersionElementQuery.perform(listOfIUs.iterator());
        LatestIUVersionElementWrapperTest.assertEquals((String)"1.0", (int)1, (int)LatestIUVersionElementWrapperTest.queryResultSize((IQueryResult)collector));
        IInstallableUnit collectedIU = this.getIU(collector.iterator().next());
        LatestIUVersionElementWrapperTest.assertEquals((String)"1.1", (IInstallableUnit)unit2, (IInstallableUnit)collectedIU);
    }

    public void testMultipleIUsAndVersions() {
        IQuery latestIuVersionElementQuery = QueryUtil.createLatestIUQuery();
        IInstallableUnit unit1 = LatestIUVersionElementWrapperTest.createIU((String)"A", (Version)Version.createOSGi((int)1, (int)0, (int)0));
        IInstallableUnit unit2 = LatestIUVersionElementWrapperTest.createIU((String)"A", (Version)Version.createOSGi((int)1, (int)0, (int)1));
        IInstallableUnit unit3 = LatestIUVersionElementWrapperTest.createIU((String)"B", (Version)Version.createOSGi((int)1, (int)0, (int)1));
        IInstallableUnit unit4 = LatestIUVersionElementWrapperTest.createIU((String)"B", (Version)Version.createOSGi((int)0, (int)1, (int)1));
        IInstallableUnit unit5 = LatestIUVersionElementWrapperTest.createIU((String)"C", (Version)Version.createOSGi((int)0, (int)1, (int)1));
        ArrayList<IInstallableUnit> listOfIUs = new ArrayList<IInstallableUnit>();
        listOfIUs.add(unit1);
        listOfIUs.add(unit2);
        listOfIUs.add(unit3);
        listOfIUs.add(unit4);
        listOfIUs.add(unit5);
        IQueryResult collector = latestIuVersionElementQuery.perform(listOfIUs.iterator());
        LatestIUVersionElementWrapperTest.assertEquals((String)"1.0", (int)3, (int)LatestIUVersionElementWrapperTest.queryResultSize((IQueryResult)collector));
        LatestIUVersionElementWrapperTest.assertContains((String)"1.2", (IQueryResult)collector, (Object)unit2);
        LatestIUVersionElementWrapperTest.assertContains((String)"1.3", (IQueryResult)collector, (Object)unit3);
        LatestIUVersionElementWrapperTest.assertContains((String)"1.4", (IQueryResult)collector, (Object)unit5);
    }
}

