/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.osgi.framework.Version;

public class GenerateTestData {
    static final String baseBundleName = "My Bundle";
    static final String baseBundleId = "com.example.bundle";
    static final Version bundleVersion = new Version("1.0");
    static final String baseFeatureName = "My feature";
    static final String baseFeatureId = "com.example.feature";
    static final Version featureVersion = new Version("1.0");
    static int numFeatures = 0;
    static int numBundles = 0;
    static int numRequires = 0;
    static File outputFile = null;
    static Random random = new Random(System.currentTimeMillis());
    Set<TestFeature> features = new HashSet<TestFeature>();
    List<TestBundle> bundles = new ArrayList<TestBundle>();

    public static void main(String[] args) throws IOException {
        GenerateTestData.processCommandLineArgs(args);
        if (!GenerateTestData.validate()) {
            GenerateTestData.printUsage();
            return;
        }
        new GenerateTestData().generate();
    }

    static void printUsage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nUse this application to generate test feature and bundle data.\n");
        buffer.append("Parameters:\n");
        buffer.append("-output <location>\n");
        buffer.append("-features <number of features>\n");
        buffer.append("-bundles <number of bundles>\n");
        buffer.append("-requires <max number of requires for each bundle> [optional]\n");
        buffer.append("\tSpecifying a requires of X bundles picks up to X of previously created bundles to be required.\n");
        buffer.append("\tThis means bundles produced at the end are more likely to have X requirements.\n");
        buffer.append("\tThis is done to avoid circular dependencies.\n");
        System.err.println(buffer.toString());
    }

    static boolean validate() {
        StringBuffer buffer = new StringBuffer();
        if (outputFile == null) {
            buffer.append("Need to set an output directory.\n");
        }
        if (numFeatures < 0 || numBundles <= 0) {
            buffer.append("Need to specifiy at least one bundle.\n");
        }
        if (numFeatures > numBundles) {
            buffer.append("Number of features must be the same or less than the number of bundles.\n");
        }
        if (numRequires > numBundles - 1) {
            buffer.append("Cannot have more required bundles than bundles.\n");
        }
        if (buffer.length() == 0) {
            return true;
        }
        System.err.println(buffer.toString());
        return false;
    }

    static void processCommandLineArgs(String[] args) {
        int i = 0;
        while (i < args.length - 1) {
            String arg = args[i];
            String next = args[++i];
            if ("-features".equalsIgnoreCase(arg)) {
                numFeatures = Integer.parseInt(next);
            } else if ("-bundles".equalsIgnoreCase(arg) || "-plugins".equalsIgnoreCase(arg)) {
                numBundles = Integer.parseInt(next);
            } else if ("-requires".equalsIgnoreCase(arg)) {
                numRequires = Integer.parseInt(next);
            } else if ("-output".equalsIgnoreCase(arg)) {
                outputFile = new File(next);
            }
            ++i;
        }
    }

    void generate() throws IOException {
        System.out.println("Generating " + numBundles + " bundles.");
        int i = 0;
        while (i < numBundles) {
            TestBundle bundle = this.generateBundle(baseBundleName + i, baseBundleId + i, bundleVersion);
            this.bundles.add(bundle);
            ++i;
        }
        System.out.println("Generating " + numFeatures + " features.");
        i = 0;
        while (i < numFeatures) {
            TestFeature feature = this.generateFeature(baseFeatureName + i, baseFeatureId + i, featureVersion, i);
            this.features.add(feature);
            ++i;
        }
        this.save();
    }

    void save() throws IOException {
        File location;
        outputFile.mkdirs();
        File featuresDir = new File(outputFile, "features");
        featuresDir.mkdirs();
        File pluginsDir = new File(outputFile, "plugins");
        pluginsDir.mkdirs();
        System.out.println("Writing " + this.features.size() + " features.");
        for (TestFeature feature : this.features) {
            File featureDir = new File(featuresDir, String.valueOf(feature.id) + '_' + feature.version);
            location = new File(featureDir, "feature.xml");
            this.write(location, feature.getManifest());
        }
        System.out.println("Writing " + this.bundles.size() + " bundles.");
        for (TestBundle bundle : this.bundles) {
            File pluginDir = new File(pluginsDir, String.valueOf(bundle.id) + '_' + bundle.version);
            location = new File(new File(pluginDir, "META-INF"), "MANIFEST.MF");
            this.write(location, bundle.getManifest());
        }
    }

    void write(File location, String data) throws IOException {
        File parent = location.getParentFile();
        if (parent == null) {
            throw new RuntimeException("Unable to write to: " + location.getAbsolutePath() + "due to null parent.");
        }
        parent.mkdirs();
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(location));
            output.write(data.getBytes());
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    TestBundle getRandomBundle() {
        if (this.bundles.isEmpty()) {
            return null;
        }
        int index = random.nextInt(this.bundles.size());
        return this.bundles.get(index);
    }

    TestBundle generateBundle(String name, String id, Version version) {
        TestBundle bundle = new TestBundle();
        bundle.id = id;
        bundle.name = name;
        bundle.version = version;
        int i = 0;
        while (i < numRequires) {
            TestBundle req = this.getRandomBundle();
            if (req != null) {
                bundle.requires.add(req);
            }
            ++i;
        }
        return bundle;
    }

    TestFeature generateFeature(String name, String id, Version version, int index) {
        TestFeature feature = new TestFeature();
        feature.id = id;
        feature.name = name;
        feature.version = version;
        TestBundle bundle = this.bundles.get(index);
        if (bundle == null) {
            throw new RuntimeException("Could not find bundle at index: " + index + " to match feature: " + id);
        }
        feature.requires.add(bundle);
        return feature;
    }

    static class TestBundle
    extends TestObject {
        TestBundle() {
        }

        String getManifest() {
            StringBuffer manifest = new StringBuffer();
            manifest.append("Manifest-Version: 1.0\n");
            manifest.append("Bundle-RequiredExecutionEnvironment: J2SE-1.4\n");
            manifest.append("Bundle-ManifestVersion: 2\n");
            manifest.append("Bundle-Name: " + this.name + '\n');
            manifest.append("Bundle-SymbolicName: " + this.id + '\n');
            manifest.append("Bundle-Version: " + this.version + '\n');
            if (!this.requires.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Require-Bundle: ");
                Iterator iter = this.requires.iterator();
                while (iter.hasNext()) {
                    TestObject req = (TestObject)iter.next();
                    buffer.append(req.id);
                    if (!iter.hasNext()) continue;
                    buffer.append(",\n ");
                }
                manifest.append(buffer.toString());
            }
            return manifest.toString();
        }
    }

    static class TestFeature
    extends TestObject {
        TestFeature() {
        }

        String getManifest() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            buffer.append("\t<feature\n");
            buffer.append("\t\tid=\"" + this.id + "\"\n");
            buffer.append("\t\tlabel=\"" + this.name + "\"\n");
            buffer.append("\t\tversion=\"" + this.version + "\"\n");
            buffer.append("\t\tprovider-name=\"providerName\"\n");
            buffer.append("\t\timage=\"eclipse_update_120.jpg\">\n");
            buffer.append("\t<description>\n");
            buffer.append("\t\tdescription\n");
            buffer.append("\t</description>\n");
            buffer.append("\t<copyright>\n");
            buffer.append("\t\tcopyright\n");
            buffer.append("\t</copyright>\n");
            buffer.append("\t<license url=\"licenseURL\">\n");
            buffer.append("\t\tlicense\n");
            buffer.append("\t</license>\n");
            for (TestObject bundle : this.requires) {
                buffer.append("\t<plugin\n");
                buffer.append("\t\tid=\"" + bundle.id + "\"\n");
                buffer.append("\t\tdownload-size=\"0\"\n");
                buffer.append("\t\tinstall-size=\"0\"\n");
                buffer.append("\t\tversion=\"" + bundle.version + "\"/>\n");
            }
            buffer.append("</feature>\n");
            return buffer.toString();
        }
    }

    static abstract class TestObject {
        String name;
        String id;
        Version version;
        Set<TestObject> requires = new HashSet<TestObject>();

        TestObject() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TestBundle)) {
                return false;
            }
            TestBundle other = (TestBundle)obj;
            return this.id.equals(other.id) && this.version.equals((Object)other.version);
        }

        public int hashCode() {
            return this.id.hashCode() + this.version.hashCode();
        }

        abstract String getManifest();
    }
}

