/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLicenseConsistency
extends AbstractProvisioningTest {
    public void testLicenses() throws URISyntaxException, ProvisionException, OperationCanceledException {
        URI repoLocation = new URI("http://download.eclipse.org/releases/indigo/201103180900");
        IMetadataRepository repo = TestLicenseConsistency.getMetadataRepositoryManager().loadRepository(repoLocation, null);
        IQueryResult allFeatures = repo.query(QueryUtil.createIUGroupQuery(), null);
        IQueryResult platform = allFeatures.query(QueryUtil.createIUQuery((String)"org.eclipse.platform.feature.group"), null);
        TestLicenseConsistency.assertFalse((boolean)allFeatures.isEmpty());
        TestLicenseConsistency.assertFalse((boolean)platform.isEmpty());
        IInstallableUnit platformFeature = (IInstallableUnit)platform.iterator().next();
        ILicense platformLicense = (ILicense)platformFeature.getLicenses(null).iterator().next();
        ArrayList<IInstallableUnit> noLicense = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> extraLicense = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> goodLicense = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> badLicense = new ArrayList<IInstallableUnit>();
        this.checkLicenses(platformLicense, (IQueryResult<IInstallableUnit>)allFeatures, goodLicense, badLicense, noLicense, extraLicense);
        this.printReport(goodLicense, badLicense, noLicense, extraLicense);
    }

    private void printReport(List<IInstallableUnit> goodLicense, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        String SPACER = "\n=======================";
        System.out.println("\n\nSummary:" + SPACER);
        System.out.println("Features with conforming license: " + goodLicense.size());
        System.out.println("Features with different license: " + badLicense.size());
        System.out.println("Features with no license: " + noLicense.size());
        System.out.println("Features with extra licenses: " + extraLicense.size());
        System.out.println("=======================");
        System.out.println("\n\nDetails:" + SPACER);
        System.out.println("Features with no license:" + SPACER);
        for (IInstallableUnit unit : this.sort(noLicense)) {
            System.out.println(String.valueOf(unit.getId()) + ' ' + unit.getVersion());
        }
        System.out.println("\n\nFeatures with different license:" + SPACER);
        for (IInstallableUnit unit : this.sort(badLicense)) {
            System.out.println(String.valueOf(unit.getId()) + ' ' + unit.getVersion());
        }
        System.out.println("\n\nFeatures with matching license:" + SPACER);
        for (IInstallableUnit unit : this.sort(goodLicense)) {
            System.out.println(String.valueOf(unit.getId()) + ' ' + unit.getVersion());
        }
    }

    private List<IInstallableUnit> sort(List<IInstallableUnit> noLicense) {
        Collections.sort(noLicense);
        return noLicense;
    }

    private void checkLicenses(ILicense platformLicense, IQueryResult<IInstallableUnit> allFeatures, List<IInstallableUnit> goodLicense, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        for (IInstallableUnit feature : allFeatures.toUnmodifiableSet()) {
            if (!feature.getId().endsWith(".feature.group")) continue;
            Collection licenses = feature.getLicenses(null);
            if (licenses.isEmpty()) {
                noLicense.add(feature);
                continue;
            }
            if (licenses.size() != 1) {
                extraLicense.add(feature);
                continue;
            }
            ILicense featureLicense = (ILicense)licenses.iterator().next();
            if (!platformLicense.getUUID().equals(featureLicense.getUUID())) {
                badLicense.add(feature);
                continue;
            }
            goodLicense.add(feature);
        }
    }
}

