/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.TestActivator;

public class ArtifactRepositoryMock
implements InvocationHandler {
    private String artifactResource;

    public static IArtifactRepository getMock(String artifactResource) {
        return (IArtifactRepository)Proxy.newProxyInstance(IArtifactRepository.class.getClassLoader(), new Class[]{IArtifactRepository.class}, (InvocationHandler)new ArtifactRepositoryMock(artifactResource));
    }

    private ArtifactRepositoryMock(String artifactResource) {
        this.artifactResource = artifactResource;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getName().equals("getArtifact")) {
            throw new RuntimeException("Unexpected usage!");
        }
        return this.getArtifact((IArtifactDescriptor)args[0], (OutputStream)args[1], (IProgressMonitor)args[2]);
    }

    private IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        try {
            InputStream inputStream = TestActivator.getContext().getBundle().getEntry(this.artifactResource).openStream();
            FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)destination, (boolean)true);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.equinox.p2.test", ":-(", (Throwable)e);
        }
    }
}

