/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ZipVerifierStep;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Bundle;

public class ZipVerifierProcessorTest
extends TestCase {
    public ZipVerifierProcessorTest(String name) {
        super(name);
    }

    public ZipVerifierProcessorTest() {
        super("");
    }

    public void testGoodZip() throws IOException {
        ZipVerifierStep step = new ZipVerifierStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/zipValidation/a.zip").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ZipVerifierProcessorTest.assertEquals((int)step.getStatus().getSeverity(), (int)0);
    }

    public void testBogusFile() throws IOException {
        ZipVerifierStep step = new ZipVerifierStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/zipValidation/a.txt").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ZipVerifierProcessorTest.assertEquals((int)step.getStatus().getSeverity(), (int)4);
    }

    public void testBogusFile2() throws IOException {
        ZipVerifierStep step = new ZipVerifierStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/zipValidation/org.eclipse.mylyn.bugzilla.core_2.3.2.v20080402-2100.jar").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ZipVerifierProcessorTest.assertEquals((int)step.getStatus().getSeverity(), (int)4);
    }

    public void testBogusFile3() throws IOException {
        ZipVerifierStep step = new ZipVerifierStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/zipValidation/bogusa.zip").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ZipVerifierProcessorTest.assertEquals((int)step.getStatus().getSeverity(), (int)4);
    }

    public void testPackGZFile() throws IOException {
        ZipVerifierStep step = new ZipVerifierStep();
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        step.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = TestActivator.getContext().getBundle();
        InputStream inputStream = bundle.getEntry("testData/zipValidation/org.eclipse.equinox.p2.updatechecker.source_1.0.0.v20080427-2136.jar.pack.gz").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)step, (boolean)true);
        ZipVerifierProcessorTest.assertEquals((int)step.getStatus().getSeverity(), (int)4);
    }
}

